<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<?php
 if(!isset($_GET['domain']) || !isset($_GET['account_id'])){
    die("Empty Domain or Account ID!!");       
 }else{
    $domain = $_GET['domain']; 
    $aid = $_GET['account_id'];        
 }
?>
<?php require_once("header.php");?>
 <!-- Begin Page Content -->
  <div class="container-fluid">

<!-- Page Heading -->
<h1 class="h3 mb-4 text-gray-800">Time Frames</h1>
<div class="container-fluid">
                <div class="card shadow mb-4">
                <div class="card-body">          
                <div class="table-responsive">
                <table class="table table-hover table-condensed">
                    <thead style="background-color:rgb(78,115,223); color:white;">
                              <tr><th colspan="4" class="text-center">Domain: <?=$domain;?> <button class="btn btn-info" onclick="createTimeFrame();">Create Time Frame</button> </th></tr>
                              <tr><th>Name</th><th>Read</th><th>Delete</th></tr>
                    </thead>
                    
          </table>
          
          
          <div class="div-table-content">
                        <table class="table table-condensed table-striped table-hover">
                             <tbody id="allList">
                             <tr id="loadingBar"><td colspan="4" class="text-center">Loading..</td></tr>
                    </tbody>
                        </table>
                    </div>
</div>
</div>
</div>
</div>
</div>


<!-- The Modal -->
<div class="modal" id="myModalTimeFrame">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title">Time Frame : <b id="tfnameModel"></b></h4>      <i id="loadTimeFrame" class="fa-2x" style="float:right;"><i class="fas fa-spinner fa-spin"></i></i>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
   
      <!-- Modal body -->
      <div class="modal-bodyTimeFrame">
          <div class="container">
              
          <div class="row edit">
              <div class="col-md-6">
                  <h4>When</h4>
              </div>
              <div class="col-md-6">
                <input type="radio" id="Always" name="whene" value="Always">
                <label for="Always"><b>Always</b></label><br>
                <input type="radio" id="DWT" name="whene" value="DWT">
                <label for="DWT"><b>Days of the week and times</b></label><br>
                <input type="radio" id="SDR" name="whene" value="SDR">
                <label for="SDR"><b>Specific dates or ranges</b></label>
              </div>
          </div>
              <div class="row createTF" style="display:none;">
                  <div class="col-md-12 col-sm-12 d-flex align-items-center justify-content-center form-inline pt-3 pb-3">
                     
                                      <div class="form-group">
                                           <label for="timeFrameName"><b>Name</b></label> &nbsp &nbsp &nbsp
                                          <input type="text" id="timeFrameName" name="timeFrameName" class="form-control col-md-12">
                                      </div>
                  </div>
                  <b>What are your bussiness hours?</b></br></br></br>
                  <div class="col-md-6">
                      <input type="radio" id="MTF" name="when" value="MTF">
                      <label for="MTF"><b>Monday - Friday</b></label><br>
                      
                      <input type="radio" id="MTFCFL" name="when" value="MTFCFL">
                      <label for="MTFCFL"><b>Monday - Friday, closed for launch</b></label><br>
                      
                      <input type="radio" id="MTFST" name="when" value="MTFST">
                      <label for="MTFST"><b>Monday - Saturday (same time)</b></label><br>
                      
                      <input type="radio" id="MTFSTDTS" name="when" value="MTFSTDTS">
                      <label for="MTFSTDTS"><b>Monday - Saturday (same time, MTF, different time Sat)</b></label><br>
                      
                       <input type="radio" id="other" name="when" value="other">
                      <label for="other"><b>Holidays</b></label></br></br></br></br>
                  </div>
                  <div class="col-md-6">
                      
                          <div class="row text-center">
                                  
                                  <div class="col-md-3 col-sm-3 wduo" style="display:none;">
                                      <div class="form-group">
                                          <label for="wduo"> When did you open?</label><br>
                                          <input type="time" id="wduo" name="wduo" class="form-control">
                                      </div>
                                  </div>
                                  
                                  <div class="col-md-3 col-sm-3 pt-4 ls" style="display:none;">
                                      <div class="form-group">
                                          <label for="ls">Lunch Start?</label><br>
                                          <input type="time" id="ls" name="ls"  class="form-control">
                                      </div>
                                  </div>
                          
                                  <div class="col-md-3 col-sm-3 pt-4 le" style="display:none;">
                                      <div class="form-group">
                                          <label for="le"> Lunch End?</label><br>
                                          <input type="time" id="le" name="le"  class="form-control">
                                      </div>
                                  </div>
                                  
                                  <div class="col-md-3 col-sm-3 wduc" style="display:none;">
                                      <div class="form-group">
                                           <label for="wduc">When did you close?</label><br>
                                           <input type="time" id="wduc" name="wduc"  class="form-control">
                                      </div>
                                  </div>
                                  
                                  
                                  <div class="col-md-3 col-sm-3 MF-S-SD-S" style="display:none;">
                                      <div class="form-group">
                                          <label for="MF-S"> MF Start?</label><br>
                                          <input type="time" id="MF-S" name="MF-S"  class="form-control"></br>
                                      </div>
                        
                                      <div class="form-group">
                                          <label for="SD-S"> Sat Start?</label><br>
                                          <input type="time" id="SD-S" name="SD-S"  class="form-control"></br>
                                      </div>
                                 </div>
                                  
                                  
                                  <div class="col-md-3 col-sm-3 MF-E-SD-E" style="display:none;">    
                                       <div class="form-group">
                                           <label for="MF-E"> MF End?</label><br>
                                           <input type="time" id="MF-E" name="MF-E"  class="form-control"></br>
                                      </div>
                                      
                                      <div class="form-group">
                                          <label for="SD-E"> Sat Start?</label><br>
                                          <input type="time" id="SD-E" name="SD-E"  class="form-control"></br>
                                      </div>
                                 </div>
                                  
                                 
                          </div>
                          
                      
                          <div class="row holidays" style="display:none">
                              <table class="table table-responsive table-hover table-striped">
                                  <thead class="table-dark">
                                  <tr><th>Select</th></td><th>What Holidays are you closed?</th><th>Day Before</th><th>On Day</th><th>Day After</th></tr>
                                  </thead>
                                  <tbody id='holidays'>
                                     
                                  </tbody>
                                  
                              </table>
                          
                          </div>
                      </div>
                      
                      
                  </div>
              </div>
          </div>
    
     

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button>
        <button type="button" class="btn btn-success" id="edit">Edit</button>
         <button type="button" class="btn btn-success" id="save" onclick="save()">Save</button>
      </div>

    </div>
  </div>
</div>

<!-- /.container-fluid -->

<script>




function createTimeFrame(){
   $("#loadTimeFrame,#edit,.edit").hide();    
   $(".createTF,#save").show(); 
   $('#myModalTimeFrame').modal('show');
   
}

function save(){
     var tmcv = $('input[type=radio][name=when]:checked').val();
     var tfname = $("#timeFrameName").val();
     
     if(tfname.length == 0){
         swal("Set the time frame name", {icon: "error", });
     }else if(typeof tmcv === "undefined"){
         swal("Set the time frame", {icon: "error", });
     }else{
         
         var wduo,wduc,MFS,SDS,MFE,SDE,ls,le;
         wduo = $("#wduo").val();
         wduc = $("#wduc").val();
         MFS = $("#MF-S").val();
         SDS = $("#SD-S").val();
         MFE = $("#MF-E").val();
         SDE = $("#SD-E").val();
         ls = $("#ls").val();
         le = $("#le").val();
         
         
         switch(tmcv){
                case 'MTF':
                    if(wduo.length==0 ||  wduc.length==0){
                        swal("You need to set both dates!", {icon: "error", });
                    }else{
                        createTFAjax(tfname,'1-5',wduo,wduc,'now','never',0,0,'no');
                    }
                break;
                
                case 'MTFST':
                    if(wduo.length==0 ||  wduc.length==0){
                        swal("You need to set both dates!", {icon: "error", });
                    }else{
                        createTFAjax(tfname,'1-6',wduo,wduc,'now','never',0,0,'no');
                    }
                break;
                
                case 'MTFSTDTS':
                
                    if(MFS.length==0 ||  SDS.length==0 ||  MFE.length==0 ||  SDE.length==0){
                        swal("You need to set all dates!", {icon: "error", });
                    }else{
                        
                        createTFAjax(tfname,'1-5',MFS,MFE,'now','never',0,1,'no');
                        createTFAjax(tfname,'6',SDS,SDE,'now','never',1,1,'no');
                        setTimeout(bulkSaver, 3000);
                    }
                    
                break;   
                
                
                case 'MTFCFL':
                
                    if(wduo.length==0 ||  wduc.length==0 ||  ls.length==0 ||  le.length==0){
                        swal("You need to set all dates!", {icon: "error", });
                    }else{
                        
                        createTFAjax(tfname,'1-5',ls,le,'now','never',0,0,'yes');
                        //setTimeout(bulkSaver, 2000);
                    }
                    
                break;   
                
                case 'other':
                    
                   
                      var checkedRowsData = [];
                      $('#holidays input.enable-disable-row:checked').each(function() {
                        var rowData = $(this).closest('tr').find('td').map(function() {
                          if ($(this).find('input').is(':checkbox')) {
                              return $(this).find('input').prop('checked') ? $(this).find('input').val() : '';
                            }
                        }).get();
                        checkedRowsData.push(rowData);
                      });
                      
                      if(checkedRowsData==''){
                          swal("Select holidays at least one!", {icon: "error", });
                          return;
                      }
                     
                      var loopLen=0;
                      $.each(checkedRowsData,function(index,item){
                          console.log(item);
                          
                          //all days
                          if(item[1]!='' && item[2]!='' && item[3]!=''){
                             
                              createTFAjax(tfname,'*','12:00','23:59',item[1],item[3],index,1,'no');
                        
                          }else if(item[1]!='' && item[2]!=''  && item[3]==''){
                             //day before , on date 
                             
                              createTFAjax(tfname,'*','12:00','23:59',item[1],item[2],index,1,'no');
                              
                          }else if(item[2]!='' && item[3]!=''){
                              //on day, day after
                               createTFAjax(tfname,'*','12:00','23:59',item[2],item[3],index,1,'no');
                              
                          }else if(item[1]!='' && item[2]=='' && item[3]==''){
                              //day before
                               createTFAjax(tfname,'*','12:00','23:59',item[1],item[1],index,1,'no');
                               
                          }else if(item[1]=='' && item[2]!='' && item[3]==''){
                              //on day
                               createTFAjax(tfname,'*','12:00','23:59',item[2],item[2],index,1,'no');
                               
                          }else if(item[1]=='' && item[2]=='' && item[3]!=''){
                              //day after
                                createTFAjax(tfname,'*','12:00','23:59',item[3],item[3],index,1,'no');
                                
                          }else if(item[1]!='' && item[2]=='' && item[3]!=''){
                              //day before,after
                               createTFAjax(tfname,'*','12:00','23:59',item[1],item[1],index,1,'no');
                                createTFAjax(tfname,'*','12:00','23:59',item[3],item[3],index,1,'no');
                          }else{
                               swal("Select date!", {icon: "error", });
                               return;
                          }
                          
                          loopLen = index;
                      });
                    //  alert(loopLen);
                      if(checkedRowsData.length==loopLen+1){
                            bulkSaver();
                      }
                      
                
            
                    
                break;    
                
               default:
                swal("Comming Soon!", {icon: "warning", });
               break;
            }
            
            
         
     }
}

function bulkSaver(){
    swal("TimeFrame submitted", {icon: "success", });
    $("#save").html("Save");
    getTimeFrames();
    $('#myModalTimeFrame').modal('hide');
    location.reload();
}

function createTFAjax(tfname,days,from_time,to_time,from_date,to_date,id,bulk,invert){
    $("#save").html('Wait <i class="fas fa-spinner fa-spin"></i>');
    $("#save").attr("disabled",true);
    $.ajax({
       url: '../apis/pbx.php',
       data: {'domain':'<?=$domain;?>','account_id':'<?=$aid;?>','CreateTimeFrame':'1','tfname':tfname,'days':days,'from_time':from_time,'to_time':to_time,'from_date':from_date,'to_date':to_date,'id':id,'invert':invert},
       method: 'GET',
       success:function(data){
           
           if(bulk==0){
                swal("TimeFrame submitted", {icon: "success", });
                $("#save").html("Save");
                getTimeFrames();
                $('#myModalTimeFrame').modal('hide');
                location.reload();
           }else{
              
           }
         
       },
       error:function(){
           alert("Error in Saving time frames");
           $("#edit").html("Save");
           $("#edit").attr("disabled",false);
       }
    });
}


function getTimeFrames(){
    var tfn = [];
    $.ajax({
       url: '../apis/pbx.php',
       data: {'domain':'<?=$domain;?>','account_id':'<?=$aid;?>','ReadTimeFrame':'1','tfname':'all'},
       method: 'GET',
       success:function(data){
           $("#loadingBar").hide();
           $("#allList").html('');
           $.each(data['data']['timerange'],function(index,item){
              //console.log(jQuery.inArray(item['time_frame'], tfn));
               if(jQuery.inArray(item['time_frame'], tfn)==-1){
                    $("#allList").append("<tr><td>"+item['time_frame']+"</td><td><button class='btn btn-success' onclick=readTimeFrame('"+item['time_frame']+"');>Edit/Read</button></td><td><button class='btn btn-danger' onclick=deleteTimeFrame('"+encodeURIComponent(item['time_frame'])+"'); id='"+item['time_frame']+"'>Delete</button></td></tr>");
                    tfn.push(item['time_frame']);
               }
              
           });
       },
       error:function(){
           alert("Error in reading time frames");
       }
    });
}


function deleteTimeFrame(tfname){
    
    var tfname = decodeURIComponent(tfname);
    swal({
      title: "Are you sure?",
      text: "Once deleted, you will not be able to recover this!",
      icon: "warning",
      buttons: true,
      dangerMode: true,
    })
    .then((willDelete) => {
      if (willDelete) {
            $("#loadingBar").show();
            $("#"+tfname).html("Wait..");
            $.ajax({
               url: '../apis/pbx.php',
               data: {'domain':'<?=$domain;?>','account_id':'<?=$aid;?>','DeleteTimeFrame':'1','tfname':tfname},
               method: 'GET',
               success:function(data){
                swal("Time frame deleted", {
                  icon: "success",
                });
                   getTimeFrames();
               },
               error:function(){
                   alert("Error in delete time frames");
               }
            });
      } else {
        //swal("Not deleted!");
      }
    });
    
    
}


function readTimeFrame(tfname){
    $("#loadTimeFrame").show();
    $("input[name='whene']").prop("checked",false);
    $.ajax({
       url: '../apis/pbx.php',
       data: {'domain':'<?=$domain;?>','account_id':'<?=$aid;?>','ReadTimeFrame':'1','tfname':tfname},
       method: 'GET',
       success:function(data){
              $("#loadTimeFrame").hide();
              if(jQuery.isArray(data['data']['timerange'])){
                   $.each(data['data']['timerange'],function(index,item){ });
              }else{
                  //console.log(data)
                  if(data['data']['timerange']['days']=='*'){
                  $("input[name='whene'][value='Always']").prop("checked",true);
                  } 
              }
              
              
          
       },
       error:function(){
           alert("Error in reading time frames");
       }
    });
    
    $("#tfnameModel").html(tfname);
    $('#myModalTimeFrame').modal('show');
    $(".edit,#edit").show();
    $(".createTF,#save").hide();
}

     $(document).ready(function(){
        getTimeFrames();
        $("#timeFrameName,modal-title").val('');
        $('input[type=radio][name=when]').change(function() {
            var value = $(this).val();
            
            switch(value){
                case 'MTF':
                    $('.wduo,.wduc').show();
                    $('.ls,.le,.MF-S-SD-S,.MF-E-SD-E,.holidays').hide();
                break; 
                
                case 'MTFCFL':
                    $('.wduo,.wduc,.ls,.le').show();
                     $('.holidays,.MF-S-SD-S,.MF-E-SD-E').hide();
                break; 
                
                case 'MTFST':
                    $('.wduo,.wduc').show();
                    $('.ls,.le,.MF-S-SD-S,.MF-E-SD-E,.holidays').hide();
                break;
                
                case 'MTFSTDTS':
                     $('.ls,.le,.wduo,.wduc,.holidays').hide();
                    $('.MF-S-SD-S,.MF-E-SD-E').show();
                break;  
                
                 case 'MTFSTDTS':
                     $('.ls,.le,.wduo,.wduc,.MF-S-SD-S,.MF-E-SD-E').hide();
                break;
                
                case 'other':
                    $('.holidays').show();
                     $('.ls,.le,.wduo,.wduc,.MF-S-SD-S,.MF-E-SD-E').hide();
                      $("#timeFrameName,modal-title").val('Holidays');
                break;    
                
            }
        });
        
        $("#timeFrameName").keyup(function(){
            $("#tfnameModel").text($(this).val());
        });
        
     });  
     

 function dateToUS(dateString,days){

          
                    const date = new Date(dateString);

                    if(days > 0){
                      date.setDate(date.getDate() +days);
                    }else if(days < 0){
                      date.setDate(date.getDate() +days);        
                    }
                   
                    // Get the year, month, and day in US Standard format
                    const year = date.getFullYear();
                    const month = date.getMonth() + 1; // Months are 0-indexed in JavaScript, so add 1
                    const day = date.getDate();

                    // Format the date string in MM/DD/YYYY format
                    const formattedDate = `${year}-${month.toString().padStart(2, '0')}-${day.toString().padStart(2, '0')}`;

                    return formattedDate; 
 }     
     
 function DATE(y, m, d) { return new Date(y, m - 1, d, 0, 0, 0, 0); }
          function WEEKDAY(date) { return 1 + date.getDay(); }
          function CHOOSE(list) { return list[0]<list.length ? list[list[0]] : 0; }
          function MOD(value, modulus) { return value % modulus; }
          function INT(value) { return ~~value; }
          function AddDays(date, days) { return new Date(date.getFullYear(), date.getMonth(), date.getDate() + days); }
          class Holiday {constructor(name, date) { this.Name = name; 
                         this.Day = '   SunMonTueWedThuFriSat'.substr(WEEKDAY(date)*3,3);
                         this.Date = date; 
                         this.NearestWeekday = AddDays(date, CHOOSE([WEEKDAY(date),1,0,0,0,0,0,-1]));}}
          function GetHolidays(year) {               
            var y = year ? year : document.getElementById("Year").value;
            var holidays = [];
            holidays.push(new Holiday("New Years Day", DATE(y,1,1)));
            holidays.push(new Holiday("Martin Luther King Jr. Day", 
                  AddDays(DATE(y,1,1), 14 + CHOOSE([WEEKDAY(DATE(y,1,1)),1,0,6,5,4,3,2]))));
            holidays.push(new Holiday("Presidents Day", 
                  AddDays(DATE(y,2,1), 14 + CHOOSE([WEEKDAY(DATE(y,2,1)),1,0,6,5,4,3,2]))));
            var easterOffset =((MOD(INT(y/100)-INT(INT(y/100)/4)-INT((8*INT(y/100)+13)/25)+
            19*MOD(y,19)+15,30)-INT(MOD(INT(y/100)-INT(INT(y/100)/4)-INT((8*INT(y/100)+13)/25)
            +19*MOD(y,19)+15,30)/28)*(1-INT(MOD(INT(y/100)-INT(INT(y/100)/4)-INT((8*INT(y/100)+13)/25)
            +19*MOD(y,19)+15,30)/28)*INT(29/(MOD(INT(y/100)-INT(INT(y/100)/4)-INT((8*INT(y/100)+13)/25)
            +19*MOD(y,19)+15,30)+1))*INT((21-MOD(y,19))/11)))-(MOD(y+INT(y/4)+
            (MOD(INT(y/100)-INT(INT(y/100)/4)-INT((8*INT(y/100)+13)/25)
            +19*MOD(y,19)+15,30)-INT(MOD(INT(y/100)-INT(INT(y/100)/4)-INT((8*INT(y/100)+13)/25)
            +19*MOD(y,19)+15,30)/28)*(1-INT(MOD(INT(y/100)-INT(INT(y/100)/4)-INT((8*INT(y/100)+13)/25)
            +19*MOD(y,19)+15,30)/28)*INT(29/(MOD(INT(y/100)-INT(INT(y/100)/4)-INT((8*INT(y/100)+13)/25)
            +19*MOD(y,19)+15,30)+1))*INT((21-MOD(y,19))/11)))+2-INT(y/100)+INT(INT(y/100)/4),7))+27);
            holidays.push(new Holiday("Good Friday", AddDays(DATE(y,3,1), easterOffset - 2)));
            holidays.push(new Holiday("Easter Sunday", AddDays(DATE(y,3,1), easterOffset)));
            holidays.push(new Holiday("Memorial Day", AddDays(DATE(y,6,1), -WEEKDAY(DATE(y,6,6)))));
            holidays.push(new Holiday("Juneteenth", DATE(y,6,19)));
            holidays.push(new Holiday("Independence Day", DATE(y,7,4)));
            holidays.push(new Holiday("Labor Day", 
                  AddDays(DATE(y,9,1), CHOOSE([WEEKDAY(DATE(y,9,1)),1,0,6,5,4,3,2]))));
            holidays.push(new Holiday("Columbus Day", 
                  AddDays(DATE(y,10,1), 7+CHOOSE([WEEKDAY(DATE(y,10,1)),1,0,6,5,4,3,2]))));
            holidays.push(new Holiday("Veterans Day", DATE(y,11,11)));
            holidays.push(new Holiday("Thanksgiving Day", 
                  AddDays(DATE(y,11,1), 21+CHOOSE([WEEKDAY(DATE(y,11,1)),4,3,2,1,0,6,5]))));
            holidays.push(new Holiday("Christmas", DATE(y,12,25)));
            holidays.push(new Holiday("New Years Eve", DATE(y,12,31)));
            var html = (JSON.stringify(holidays)).split('},').join('}')
                      .split('T06:00:00.000Z').join('').split('T05:00:00.000Z').join('');
            return holidays;
          }
          GetHolidays(2023).forEach(function(v){
               $("#holidays").append(' <tr><td><input type="checkbox" class="enable-disable-row"></td><td>'+v.Name+'</td><td><input value="'+dateToUS(v.Date,-1)+'" type="checkbox" disabled></td><td><input value="'+dateToUS(v.Date,0)+'" type="checkbox" disabled></td><td><input value="'+dateToUS(v.Date,+1)+'" type="checkbox" disabled></td></tr>');
          
              //$('#holidays input').prop('disabled', true);
          }); 
          
           $(document).ready(function() {
            $('.enable-disable-row').click(function() {
              var isChecked = $(this).is(':checked');
              $(this).closest('tr').find(':checkbox').not('.enable-disable-row').prop('disabled', !isChecked);
            });
          });
        </script>
<?php require_once("footer.php");?>