<?php
header("Content-type: application/json");  
require_once("../inc/helper.php");
class Pbx extends Helper{

    private $pbxBaseurl = "https://pbx.skyswitch.com/";   

    private function getToken($aid){
      $url = $this->pbxBaseurl."ns-api/oauth2/token";        
      $data = $this->call_api($url,$this->getPbxCredentials($aid),"");
      file_put_contents($this->getTokenFromFilePbx($aid),$data);
    }

    private function getHeader($aid){
      return $header = array(
                'Authorization: Bearer '.$this->tokenGenerator($aid),
                'accept: application/xml',
              );
    }

    private function tokenGenerator($aid){
      $data = json_decode(file_get_contents($this->getTokenFromFilePbx($aid)),true);
      //print_r($this->getTokenFromFilePbx($aid));
      //check is token expire then request again
      if(time()-filemtime($this->getTokenFromFilePbx($aid)) > $data['expires_in']){
         $this->getToken($aid);
         $data = json_decode(file_get_contents($this->getTokenFromFilePbx($aid)),true);
         return $data['access_token']; 
         //die($this->jsonFailed("Refresh Again -- Token Generated Account id: $aid"));
      }else{
         return $data['access_token'];       
      }
    }
   /**is account exist */
    function noOfAccountConfig($aid){
      if($this->userResellerIds()<$aid){
       die($this->jsonFailed("Account $aid doesn't exist!"));
      }
   }
    
    
    function getPbxSubscriberRead($domain,$user,$aid){
      if(empty($domain) || empty($user) || strlen($aid)==0){
        die($this->jsonFailed("Empty Domain or User or Account ID Parameter!"));
      }

      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/"; 
      $params = array(
        'object' => 'subscriber',
        'action' => 'read',
        'domain' => $domain,
        'user' => $user,
      );
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $this->xmlToJson($data);    
    
    }
    
    
     /**Update Subscriber**/
     function pbxUpdateSubscriber($domain,$aid,$user,$firstName,$lastName,$email){
      if(strlen($domain)==0 && strlen($aid)==0 && strlen($user)==0 && strlen($lastName)==0 && strlen($firstName)==0 && strlen($email)==0){
        die($this->jsonFailed("Empty Domain or Account ID or Uid or first/last name"));
      }

      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/"; 
      $params = array(
        'object' => 'subscriber',
        'action' => 'update',
        'domain' => $domain,
        'user' => $user,
        'first_name' => $firstName,
        'last_name' => $lastName,
        'email' => $email
      );
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $this->xmlToJson($data);
      //return json_encode($params);
    
    }

    function getPbxAnswerRulesRead($domain,$user,$aid){
      if(empty($domain) || empty($user) || strlen($aid)==0){
        die($this->jsonFailed("Empty Domain or User or Account ID Parameter!"));
      }

      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/"; 
      $params = array(
        'object' => 'answerrule',
        'action' => 'read',
        'domain' => $domain,
        'user' => $user,
      );
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $this->xmlToJson($data);    
    
    }

    function getPbxUserDeviceRead($domain,$aid){
      if(empty($domain) && strlen($aid)==0){
        die($this->jsonFailed("Empty Domain or Account ID!"));
      }

      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/"; 
      $params = array(
        'object' => 'device',
        'action' => 'read',
        'domain' => $domain,
      );
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $this->xmlToJson($data);    
    
    }
    
    
   
    
    /**Read Active Calls**/
     function pbxReadActiveCalls($domain,$aid){
      if(empty($domain) && strlen($aid)==0){
        die($this->jsonFailed("Empty Domain or Account ID!"));
      }

      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/"; 
      $params = array(
        'object' => 'call',
        'action' => 'read',
        'domain' => $domain,
      );
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $this->xmlToJson($data);    
    
    }
    
    /**Disconnect active call**/
     function pbxDisconnectActiveCalls($domain,$aid,$uid,$callid){
      if(strlen($domain)==0 && strlen($aid)==0 && strlen($uid)==0 && strlen($callid)==0){
        die($this->jsonFailed("Empty Domain or Account ID OR uid/callid!"));
      }

      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/"; 
      $params = array(
        'object' => 'call',
        'action' => 'disconnect',
        'uid' =>    $callid.'@'.$domain,
        'callid' => $callid,
      );
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $this->xmlToJson($data);
      //return json_encode($params);
    
    }
    
    /**make call**/
     function pbxMakeCalls($domain,$aid,$to,$from,$uid){
      if(strlen($domain)==0 && strlen($aid)==0 && strlen($callid)==0 && strlen($to)==0 && strlen($uid)==0){
        die($this->jsonFailed("Empty Domain or Account ID OR uid/callid,destination,uid!"));
      }
      
      if(strlen($from)==0){
          $from = '';
      }

      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/";
      //random no.
      $rand = time().rand(00001,99999);
      $params = array(
        'object' => 'call',
        'action' => 'call',
        'uid' =>   $uid.'@'.$domain,
        'callid' =>  $rand.'@'.$domain,
        'destination'=> $to,
        'originatiion'=> $from
      );
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $this->xmlToJson($data);
      //return json_encode($params);
    
    }
    
    
     /**Read Time frame**/
     function pbxReadTimeFrame($domain,$aid,$tfname){
      if(empty($domain) && strlen($aid)==0 && strlen($tfname)==0){
        die($this->jsonFailed("Empty Domain or Account ID!"));
      }
      
      if($tfname=="all"){
          $tfname='';
      }

      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/"; 
      $params = array(
        'object' => 'timerange',
        'action' => 'read',
        'time_frame' => $tfname,
        'owner' => '*',
        'owner_domain' => $domain,
      );
      $data = $this->call_api($url,$params,$this->getHeader($aid));
      //print_r($params);
      return $this->xmlToJson($data);    
    
    }
    
    /**delete Time frame**/
     function pbxDeleteTimeFrame($domain,$aid,$tfname){
      if(empty($domain) && strlen($aid)==0 && strlen($tfname)==0){
        die($this->jsonFailed("Empty Domain or Account ID!"));
      }

      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/"; 
      $params = array(
        'object' => 'timerange',
        'action' => 'delete',
        'time_frame' => $tfname,
        'owner' => '*',
        'owner_domain' => $domain,
      );
      $data = $this->call_api($url,$params,$this->getHeader($aid));
      //print_r($params);
      return $this->xmlToJson($data);    
    
    }
    
    /**Create Time frame**/
     function pbxCreateTimeFrame($domain,$aid,$tfname,$days,$from_time,$to_time,$from_date,$to_date,$orderID,$invert){
      if(empty($domain) && strlen($aid)==0 && strlen($tfname)==0 && strlen($days)==0 && strlen($from_time)==0 && strlen($to_time)==0 && strlen($from_date)==0 && strlen($to_date)==0 &&strlen($orderID)==0){
        die($this->jsonFailed("Empty Domain or Account ID!"));
      }
      
      if(empty($invert)){
          $invert = 'no';
      }

      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/"; 
      $params = array(
        'object' => 'timerange',
        'action' => 'create',
        'time_frame' => $tfname,
        'owner' => '*',
        'owner_domain' => $domain,
        'days' => $days,
        'tod_from' => $from_time,
        'tod_to' => $to_time,
        'invert' => $invert,
        'date_from' =>$from_date,
        'date_to' => $to_date,
        'order' => $orderID
      );
      //file_put_contents('test.txt',$params);
      $data = $this->call_api($url,$params,$this->getHeader($aid));
      //print_r($params);
      return $this->xmlToJson($data);    
    
    }
    
    
    /**Read Voice Mail**/
     function pbxReadVoiceMail($domain,$aid,$type,$user){
      if(empty($domain) && strlen($aid)==0 && strlen($type)==0 && strlen($user)==0){
        die($this->jsonFailed("Empty Domain or Account ID or Type!"));
      }

      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/"; 
      $params = array(
        "object"=>"audio",
        "action"=>"read",
        "owner_domain"=>$domain,
        "type"=>$type,
        "user"=>$user
      );
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $this->xmlToJson($data);    
    
    }
    
     /**Read CDR**/
     function pbxReadCDR($domain,$aid,$startTime,$type,$user){
	     $end_date = gmdate('Y-m-d H:i:s', strtotime('+6 hours'));
      if(empty($domain) && strlen($aid)==0 && strlen($type)==0 && strlen($user)==0){
        die($this->jsonFailed("Empty Domain or Account ID or Type!"));
      }

      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/"; 
      $params = array(
        "object"=>"cdr2",
        "action"=>"read",
        "raw"=>"yes",
        "qos"=>"yes",
        "domain"=>$domain,
        "start_date"=>$startTime,
        "end_date"=>$end_date,
        "type"=>"*",
        "start"=>1,
        "limit"=>"20000000",
        "sort"=>"desc",
        "format"=>"json"
      );
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $data;    
    
    }
    
    
    function getPbxUserIVRDialPlan($domain,$aid){
      if(empty($domain)){
        die($this->jsonFailed("Empty Domain!"));
      }
      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/"; 
      $params = array(
        'object' => 'dialplan',
        'action' => 'read',
        'domain' => $domain,
      );
     
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $this->xmlToJson($data);    
    
    }
    
   function getPbxUserIVRRead($domain,$dp,$aid){
      if(empty($domain)){
        die($this->jsonFailed("Empty Domain!"));
      }
      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/"; 
      $params = array(
        'object' => 'dialrule',
        'action' => 'read',
        'domain' => $domain,
        'dialplan' => $dp,
      );
     
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $this->xmlToJson($data);    
    
    }
    
    function getPbxUserIVRUpdateDialRule($domain,$aid,$params){
      if(empty($domain)){
        die($this->jsonFailed("Empty Domain!"));
      }
      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/?object=dialrule&action=update"; 
    //   $params = array(
    //     'object' => 'dialrule',
    //     'action' => 'update',
    //     'domain' => $domain,
    //     'dialplan' => $dp,
    //   );
     
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $this->xmlToJson($data);    
    
    }
    
    
    function getPbxUserIVRUpdateDeleteDialRule($domain,$aid,$params){
      if(empty($domain)){
        die($this->jsonFailed("Empty Domain!"));
      }
      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/?object=dialrule&action=delete"; 
    //   $params = array(
    //     'object' => 'dialrule',
    //     'action' => 'update',
    //     'domain' => $domain,
    //     'dialplan' => $dp,
    //   );
     
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $this->xmlToJson($data);    
    
    }
    
    
    function getPbxUserIVRCreateDial_Rule($domain,$aid,$params){
      if(empty($domain)){
        die($this->jsonFailed("Empty Domain!"));
      }
      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/?object=dialrule&action=create"; 
    //   $params = array(
    //     'object' => 'dialrule',
    //     'action' => 'update',
    //     'domain' => $domain,
    //     'dialplan' => $dp,
    //   );
     
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $this->xmlToJson($data);    
    
    }
    
    
    function setPbxUserCalls($domain,$aid){
      if(empty($domain) && empty($aid)){
        die($this->jsonFailed("Empty Domain or account id"));
      }
      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/?object=event&action=create"; 
      $params = array(
        'model' => 'call',
        'post_url' => 'https://htel.a2hosted.com/openapis/index.php',
        'domain' => $domain,
      );
     
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $this->xmlToJson($data);    
    
    }
    
     function getPbxUserCallRecording($domain,$aid,$oci,$tci){
      if(empty($domain) && empty($oci) && empty($tci)){
        die($this->jsonFailed("Empty Domain or orig_callid or ! term_callid"));
      }
      $this->noOfAccountConfig($aid);
      $url = $this->pbxBaseurl."ns-api/"; 
      $params = array(
        'object' => 'recording',
        'action' => 'read',
        'domain' => $domain,
        'orig_callid' => $oci,
        'term_callid' => $tci
      );
     
      $data = $this->call_api($url,$params,$this->getHeader($aid));  
      return $this->xmlToJson($data);    
    
    }
   
   
   function getPbxDomainSubscriber($domain,$aid){

      if(empty($domain) || strlen($aid)==0){
        die($this->jsonFailed("Empty Domain or Account ID Parameter"));
      }
    
      $this->noOfAccountConfig($aid);
  
      $url = $this->pbxBaseurl."ns-api/"; 
      $params = array(
        'object' => 'subscriber',
        'action' => 'read',
        'domain' => $domain,
      );
      $data = $this->call_api($url,$params,$this->getHeader($aid)); 
      $dataec =  json_decode(json_encode(simplexml_load_string($data)),true)['subscriber'];
      //print_r($dataec);
      foreach($dataec as $item){
        $dataz[$item['user']] = $item;
        $dataz[$item['user']]['accountid'] = $aid;
      }  
      
      return json_encode(array("success"=>true,"data"=>$dataz));

 }


    function getPbxListDomains(){  
    
        for($i = 0; $i <= 200; $i++){
            
            
            if($this->userResellerIds() <= $i){
                break;
            }
            
            $request = $this->getPbxCredentials($i);
            
            $url = $this->pbxBaseurl."ns-api/"; 
            
            $params = array(
                'object' => 'domain',
                'action' => 'read',
                'territory' => $this->params[$i]['territory'],
              );
            
              $response = $this->call_api($url,$params,$this->getHeader($i));
            
                $decAll = json_decode(json_encode(simplexml_load_string($response)),true)['domain'];
        
                foreach($decAll as $index=>$dec){
                    //  print_r($dec);
                  $data[$index] = array("domain" =>$dec['domain'], "reseller" => $dec['territory'],"description" => $dec['description'], "accountid"=>$i);
                }
                
                
        }
    
          return json_encode(array("success"=>true,"data"=>$data)); 
      }

}

$pbx = new Pbx();


if(isset($_GET['domains'])){
    echo $pbx->getPbxListDomains();
}
 
 if(isset($_GET['pbxListSubscribers'])&&isset($_GET['account_id'])){
    echo $pbx->getPbxDomainSubscriber($_GET['pbxListSubscribers'],$_GET['account_id']);
 }
 

 if(isset($_GET['domain'])&&isset($_GET['user'])&&isset($_GET['pbxsubsread'])&&isset($_GET['account_id'])){
 echo $pbx->getPbxSubscriberRead($_GET['domain'],$_GET['user'],$_GET['account_id']);
}

if(isset($_GET['domain'])&&isset($_GET['user'])&&isset($_GET['PbxAnswerRulesRead'])&&isset($_GET['account_id'])){
 echo $pbx->getPbxAnswerRulesRead($_GET['domain'],$_GET['user'],$_GET['account_id']);
}

if(isset($_GET['domain'])&&isset($_GET['PbxUserDeviceRead'])&&isset($_GET['account_id'])){
  echo $pbx->getPbxUserDeviceRead($_GET['domain'],$_GET['account_id']);
 }
 
if(isset($_GET['domain'])&&isset($_GET['ReadActiveCalls'])&&isset($_GET['account_id'])){
  echo $pbx->pbxReadActiveCalls($_GET['domain'],$_GET['account_id']);
 } 
 
if(isset($_GET['domain'])&&isset($_GET['UpdateSubscriber'])&&isset($_GET['account_id'])&&isset($_GET['user'])&&isset($_GET['fname'])&&isset($_GET['lname'])&&isset($_GET['email'])){
  echo $pbx->pbxUpdateSubscriber($_GET['domain'],$_GET['account_id'],$_GET['user'],$_GET['fname'],$_GET['lname'],$_GET['email']);
 }  
 
if(isset($_GET['domain'])&&isset($_GET['account_id'])&&isset($_GET['disconnect'])&&isset($_GET['uid'])&&isset($_GET['callid'])){
  echo $pbx->pbxDisconnectActiveCalls($_GET['domain'],$_GET['account_id'],$_GET['uid'],$_GET['callid']);
 }  
 
if(isset($_GET['domain'])&&isset($_GET['account_id'])&&isset($_GET['makecall'])&&isset($_GET['origin'])&&isset($_GET['dest'])&&isset($_GET['uid'])){
  echo $pbx->pbxMakeCalls($_GET['domain'],$_GET['account_id'],$_GET['dest'],$_GET['origin'],$_GET['uid']);
}  
 
 /**time frame**/

if(isset($_GET['domain'])&&isset($_GET['ReadTimeFrame'])&&isset($_GET['account_id'])&&isset($_GET['tfname'])){
    echo $pbx-> pbxReadTimeFrame($_GET['domain'],$_GET['account_id'],$_GET['tfname']);
 } 
 
 if(isset($_GET['domain'])&&isset($_GET['DeleteTimeFrame'])&&isset($_GET['account_id'])&&isset($_GET['tfname'])){
    echo $pbx->pbxDeleteTimeFrame($_GET['domain'],$_GET['account_id'],$_GET['tfname']);
 }
 
 if(isset($_GET['domain'])&&isset($_GET['CreateTimeFrame'])&&isset($_GET['account_id'])&&isset($_GET['tfname'])&&isset($_GET['days'])&&isset($_GET['from_time'])&&isset($_GET['to_time'])&&isset($_GET['from_date'])&&isset($_GET['to_date'])&&isset($_GET['id'])&&isset($_GET['invert'])){
    echo $pbx-> pbxCreateTimeFrame($_GET['domain'],$_GET['account_id'],$_GET['tfname'],$_GET['days'],$_GET['from_time'],$_GET['to_time'],$_GET['from_date'],$_GET['to_date'],$_GET['id'],$_GET['invert']);
 } 
 

  /**read voice mail**/
  
  if(isset($_GET['domain'])&&isset($_GET['account_id'])&&isset($_GET['type'])&&isset($_GET['ReadVoiceMail'])&&isset($_GET['user'])){
    echo $pbx->pbxReadVoiceMail($_GET['domain'],$_GET['account_id'],$_GET['type'],$_GET['user']);
 } 
 
 /**READ CDR**/
 if(isset($_GET['domain'])&&isset($_GET['ReadCDR'])&&isset($_GET['account_id'])&&isset($_GET['type'])&&isset($_GET['user'])&&isset($_GET['start_time'])){
    echo $pbx-> pbxReadCDR($_GET['domain'],$_GET['account_id'],$_GET['start_time'],$_GET['type'],$_GET['user']);
 }
 
 /**ivr**/
 if(isset($_GET['domain'])&&isset($_GET['account_id'])&&isset($_GET['dialplan'])&&isset($_GET['ReadDialRule'])){
    echo $pbx->getPbxUserIVRRead($_GET['domain'],$_GET['dialplan'],$_GET['account_id']);
 } 
 
 if(isset($_GET['domain'])&&isset($_GET['account_id'])&&isset($_GET['ReadDialPlan'])){
    echo $pbx->getPbxUserIVRDialPlan($_GET['domain'],$_GET['account_id']);
 } 
 
 if(isset($_GET['domain'])&&isset($_GET['account_id'])&&isset($_GET['UpdateDialRule'])){
    echo $pbx->getPbxUserIVRUpdateDialRule($_GET['domain'],$_GET['account_id'],$_GET);
 } 

if(isset($_GET['domain'])&&isset($_GET['account_id'])&&isset($_GET['DeleteDialRule'])){
    echo $pbx->getPbxUserIVRUpdateDeleteDialRule($_GET['domain'],$_GET['account_id'],$_GET);
 }
 
 if(isset($_GET['domain'])&&isset($_GET['account_id'])&&isset($_GET['CreateDialRule'])){
    echo $pbx->getPbxUserIVRCreateDial_Rule($_GET['domain'],$_GET['account_id'],$_GET);
 }
 
 if(isset($_GET['domain'])&&isset($_GET['account_id'])&&isset($_GET['subscribeCalls'])){
    echo $pbx->setPbxUserCalls($_GET['domain'],$_GET['account_id']);
 }

 
