<?php
error_reporting(1);
require_once("conn.php");
class querys extends conn{
    
    

    
    
    /**summa**/
    /**get transcription**/
    function summaTranscriptionByCdrId($cdrid){
            $temp = $this->connect->prepare("SELECT transcription FROM `summa_call_anylises` WHERE cdr_id = ?");
            $temp->execute([$cdrid]);
            if($temp->rowCount()){
                 return $temp->fetchColumn();
            }else{
                 return array();
            }
    }
    //add to favroutes
    function summaFavCall($id,$fav){
            $temp = $this->connect->prepare("UPDATE `summa_call_reports` SET fav = ? WHERE id = ?");
            $temp->execute([$fav,$id]);
            if($temp->rowCount()){
                 return 1;
            }else{
                 return 0;
            }
    }
    
    ///fetch call reports by domain all
    function summaCallReportsbyDomainAll($domain,$date,$term_sub){
        
            if($term_sub==0){
                
                $sql = "SELECT fav,id,cdr_id,orig_from_name,orig_to_user,orig_req_user,duration,time_start,step,try,term_sub FROM `summa_call_reports` WHERE domain = ? AND duration > 0 AND try < 10 AND step!='-5' AND SUBSTRING(dt,1,10) = ?  ORDER BY id DESC";
                
                $temp = $this->connect->prepare($sql);
                $temp->execute([$domain,$date]);
                
            }else{
                
               $sql = "SELECT fav,id,cdr_id,orig_from_name,orig_to_user,orig_req_user,duration,time_start,step,try,term_sub FROM `summa_call_reports` WHERE domain = ? AND duration > 0 AND try < 10 AND step!='-5' AND SUBSTRING(dt,1,10) = ? AND term_sub = ? ORDER BY id DESC";
               
              $temp = $this->connect->prepare($sql);
              $temp->execute([$domain,$date,$term_sub]);
            }
            
           
            if($temp->rowCount()){
                 return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                 return array();
            }
    }
    
    function summaCallReportsbyDomainFav($domain,$date,$term_sub){
        
            if($term_sub==0){
                
                $sql = "SELECT fav,id,cdr_id,orig_from_name,orig_to_user,orig_req_user,duration,time_start,step,try,term_sub FROM `summa_call_reports` WHERE domain = ? AND duration > 0 AND try < 10 AND step!='-5' AND  fav = '1' ORDER BY id DESC";
                
                $temp = $this->connect->prepare($sql);
                $temp->execute([$domain]);
                
            }else{
                
               $sql = "SELECT fav,id,cdr_id,orig_from_name,orig_to_user,orig_req_user,duration,time_start,step,try,term_sub FROM `summa_call_reports` WHERE domain = ? AND duration > 0 AND try < 10 AND step!='-5'  AND term_sub = ? AND fav = '1' ORDER BY id DESC";
               
              $temp = $this->connect->prepare($sql);
              $temp->execute([$domain,$term_sub]);
            }
            
           
            if($temp->rowCount()){
                 return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                 return array();
            }
    }
    
    ///fetch call reports by domain
    function summaCallReportsbyDomain($domain,$date,$term_sub){
        
            if($term_sub==0){
                
                $sql = "SELECT fav,id,cdr_id,orig_from_name,orig_to_user,orig_req_user,duration,time_start,step,try,term_sub FROM `summa_call_reports` WHERE domain = ? AND duration > 0 AND try < 10 AND step!='-5' AND release_text != 'Manual' AND SUBSTRING(dt,1,10) = ?  ORDER BY id DESC";
                
                $temp = $this->connect->prepare($sql);
                $temp->execute([$domain,$date]);
                
            }else{
                
               $sql = "SELECT fav,id,cdr_id,orig_from_name,orig_to_user,orig_req_user,duration,time_start,step,try,term_sub FROM `summa_call_reports` WHERE domain = ? AND duration > 0 AND try < 10 AND step!='-5' AND release_text != 'Manual' AND SUBSTRING(dt,1,10) = ? AND term_sub = ? ORDER BY id DESC";
               
              $temp = $this->connect->prepare($sql);
              $temp->execute([$domain,$date,$term_sub]);
            }
            
           
            if($temp->rowCount()){
                 return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                 return array();
            }
    }
    ///fetch call reports by domain & type
    function summaCallReportsbyDomainNType($domain,$date,$term_sub){
        
            if($term_sub==0){
                $sql = "SELECT fav,id,cdr_id,orig_from_name,orig_to_user,orig_req_user,duration,time_start,step,try,term_sub FROM `summa_call_reports` WHERE domain = ? AND duration > 0 AND try < 10 AND release_text = 'Manual' AND SUBSTRING(dt,1,10) = ? ORDER BY id DESC ";
                
                $temp = $this->connect->prepare($sql);
                $temp->execute([$domain,$date]);
                
            }else{
                $sql = "SELECT fav,id,cdr_id,orig_from_name,orig_to_user,orig_req_user,duration,time_start,step,try,term_sub FROM `summa_call_reports` WHERE domain = ? AND duration > 0 AND try < 10 AND release_text = 'Manual' AND SUBSTRING(dt,1,10) = ? AND term_sub = ? ORDER BY id DESC ";
                
                $temp = $this->connect->prepare($sql);
                $temp->execute([$domain,$date,$term_sub]);
            }
            
            
            if($temp->rowCount()){
                 return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                 return array();
            }
    }
    //transcript & summary by crd_id 
    function summaCallReportsTransSumryByCdr($cdr_id){
            $temp = $this->connect->prepare("SELECT COALESCE(transcription,'EMPTY') AS transcription,COALESCE(summary,'EMPTY') AS summary,dt FROM `summa_call_anylises` WHERE cdr_id = ? ORDER BY id DESC LIMIT 1");
            $temp->execute([$cdr_id]);
            if($temp->rowCount()){
                 return $temp->fetch(PDO::FETCH_ASSOC);
            }else{
                 return array();
            }
    }
    
    //get cdr details 
    function summaCallcdrDetails($cdr_id){
            $temp = $this->connect->prepare("SELECT summa_call_reports.domain,summa_call_reports.orig_from_name,summa_call_reports.orig_to_user,summa_call_reports.orig_req_user,summa_call_reports.duration,summa_call_reports.time_start,summa_call_reports.dt,summa_call_reports.udt,summa_call_reports.cdr_id,summa_domain_settings.term_sub FROM `summa_call_reports` JOIN summa_domain_settings ON summa_domain_settings.domain = summa_call_reports.domain AND summa_call_reports.term_sub=summa_domain_settings.term_sub WHERE summa_call_reports.cdr_id = ?");
            $temp->execute([$cdr_id]);
            if($temp->rowCount()){
                 return $temp->fetch(PDO::FETCH_ASSOC);
            }else{
                 return array();
            }
    }
    
     
    //login user//gen token
    function loginSumma($email){
        
        $this->connect->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
        
        try{
            
            $this->connect->beginTransaction();
            
            $temp = $this->connect->prepare("SELECT domain,term_sub FROM `summa_domain_settings` WHERE email = ?");
            $temp->execute([$email]);
            
            if($temp->rowCount()){

                $domain = $temp->fetch(PDO::FETCH_ASSOC);
                $token = base64_encode(sha1(rand(111111,999999).time())); 
                $temp2 = $this->connect->prepare("INSERT INTO `token_validator`(`domain`,`term_sub`,`token`) VALUES (?,?,?)");
                $temp2->execute(array($domain['domain'],$domain['term_sub'],$token));
    
                if($temp2->rowCount()){
                  $temp3 = $this->connect->prepare("UPDATE `token_validator` SET expire = 1 WHERE domain = ? AND term_sub = ? AND id !=?");
                  $temp3->execute([$domain['domain'],$domain['term_sub'],$domain['id']]);
                  $this->connect->lastInsertId();    
                     //insert token
                   $result = array("success"=>true,"token"=>$token,"email"=>$email); 
                }else{
                   $result = array("success"=>false,"message"=>"Something wents wrong!");
                }
                 
                 
            }else{
                 return $result = array("success"=>false,"message"=>"Invalid Login!");
            }
            
            $this->connect->commit();
            return $result;
        }catch(PDOException $e){
            $this->connect->rollBack();
            return array("success"=>false,"message"=>$e->getMessage());
        }
    } 
    
    
    
    //login checker & extender
    function loginSummaCheck($token){
        
        $this->connect->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
        
        try{
            
            $this->connect->beginTransaction();
            
            $t = explode('#',$token);
            if($t[1]=="m" & is_array($t)){//if mobile login
            
            
              $temp = $this->connect->prepare("SELECT * FROM `token_validator` WHERE token =? ");
                $temp->execute([$t[0]]);
                
                if($temp->rowCount()){
                    $login = $temp->fetch(PDO::FETCH_ASSOC);
                       //$temp3 = $this->connect->prepare("SELECT * FROM `summa_call_reports` WHERE token =? ");
                       //$temp3->execute([$t[0]]);
                         //insert token
                       $result = array("success"=>true,"domain"=>$login['domain'],"term_sub"=>$login['term_sub']); 
                 }else{
                     return $result = array("success"=>false,"message"=>"Invalid Login!");
                }
                
            }else{//if web
                
                $temp = $this->connect->prepare("SELECT * FROM `token_validator` WHERE token =? AND ADDTIME(dt,'08:00:00') > NOW() AND expire = 0");
                $temp->execute([$token]);
                
                if($temp->rowCount()){
                    $login = $temp->fetch(PDO::FETCH_ASSOC);
                    
                    $temp2 = $this->connect->prepare("UPDATE `token_validator` SET `dt`=NOW(),session = session+1 WHERE id = ?");
                    $temp2->execute(array($login['id']));
                    
                    if($temp2->rowCount()){
                         //insert token
                       $result = array("success"=>true,"domain"=>$login['domain'],"term_sub"=>$login['term_sub']); 
                    }else{
                       $result = array("success"=>false,"message"=>"Something wents wrong!");
                    }
                     
                     
                }else{
                     return $result = array("success"=>false,"message"=>"Invalid Login!");
                }
            }
            
            $this->connect->commit();
            return $result;
        }catch(PDOException $e){
            $this->connect->rollBack();
            return array("success"=>false,"message"=>"Failed login check!");
        }
    } 
    
    /**DASHBORD SUMMA STATI**/
   
    function summaStatistics($domain,$term_sub){
        
        if($term_sub!=="0"){
            $temp = $this->connect->prepare("SELECT SUM(Calls) AS Calls,SUM(Recording) AS Recording,SUM(Transcript+Summary) AS Transcript,SUM(Summary) AS Summary From (SELECT COUNT(id) AS calls,'0' AS Recording,'0' AS Transcript,'0' AS Summary FROM `summa_call_reports` WHERE domain = :domain AND term_sub = :term_sub UNION SELECT '0' AS calls,COUNT(id) AS Recording,'0' AS Transcript,'0' AS Summary FROM `summa_call_reports` WHERE audio IS NOT NULL AND domain = :domain AND term_sub = :term_sub UNION  SELECT '0' AS calls,'0' AS Recording,COUNT(id) AS Transcript,'0' AS Summary FROM `summa_call_reports` WHERE step = 2 AND domain = :domain AND term_sub = :term_sub UNION SELECT '0' AS calls,'0' AS Recording,'0' AS Transcript,COUNT(id) AS Summary FROM `summa_call_reports` WHERE step = 3 AND domain = :domain AND term_sub = :term_sub) AS T1");
            $temp->execute(array(':domain'=>$domain,':term_sub'=>$term_sub));
            
        }else if($term_sub=="0"){
            $temp = $this->connect->prepare("SELECT SUM(Calls) AS Calls,SUM(Recording) AS Recording,SUM(Transcript+Summary) AS Transcript,SUM(Summary) AS Summary From (SELECT COUNT(id) AS calls,'0' AS Recording,'0' AS Transcript,'0' AS Summary FROM `summa_call_reports` WHERE domain = :domain UNION SELECT '0' AS calls,COUNT(id) AS Recording,'0' AS Transcript,'0' AS Summary FROM `summa_call_reports` WHERE audio IS NOT NULL AND domain = :domain UNION  SELECT '0' AS calls,'0' AS Recording,COUNT(id) AS Transcript,'0' AS Summary FROM `summa_call_reports` WHERE step = 2 AND domain = :domain UNION SELECT '0' AS calls,'0' AS Recording,'0' AS Transcript,COUNT(id) AS Summary FROM `summa_call_reports` WHERE step = 3 AND domain = :domain) AS T1");
            $temp->execute(array(':domain'=>$domain));
        }
        
            if($temp->rowCount()){
                 return $temp->fetch(PDO::FETCH_ASSOC);
            }else{
                 return array();
            }
    }
    
    //all domain details
    function domainDetails($domain){
            $temp = $this->connect->prepare("SELECT * FROM `telco_domains` WHERE domain = :domain");
            $temp->execute(array(':domain'=>$domain));
            if($temp->rowCount()){
                 return $temp->fetch(PDO::FETCH_ASSOC);
            }else{
                 return array();
            }
    }
    
    //fetch auto transcription enable domain & crd
    
    function autoTranscriptIds(){
            $temp = $this->connect->prepare("SELECT summa_call_reports.domain,summa_call_reports.cdr_id FROM `summa_call_reports` JOIN summa_domain_settings ON summa_domain_settings.domain = summa_call_reports.domain AND summa_call_reports.term_sub=summa_domain_settings.term_sub  WHERE summa_domain_settings.p_transcription = 1 AND summa_call_reports.step=1 AND SUBSTRING(summa_call_reports.dt,1,10)=SUBSTRING(NOW(),1,10) ORDER BY summa_call_reports.id ASC LIMIT 5");
            $temp->execute();
            if($temp->rowCount()){
                 return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                 return array();
            }
    }
    
     function autoSummaryIds(){
            $temp = $this->connect->prepare("SELECT summa_call_reports.domain,summa_call_reports.orig_from_name,summa_call_reports.orig_to_user,summa_call_reports.orig_req_user,summa_call_reports.duration,summa_call_reports.time_start,summa_call_reports.dt,summa_call_reports.udt,summa_call_reports.cdr_id,summa_domain_settings.term_sub FROM `summa_call_reports` JOIN summa_domain_settings ON summa_domain_settings.domain = summa_call_reports.domain AND summa_call_reports.term_sub=summa_domain_settings.term_sub WHERE summa_domain_settings.p_summary = 1 AND summa_call_reports.step=2 AND SUBSTRING(summa_call_reports.dt,1,10)=SUBSTRING(NOW(),1,10) ORDER BY summa_call_reports.id LIMIT 5");
            $temp->execute();
            if($temp->rowCount()){
                 return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                 return array();
            }
    }
    
    //get domain whos summa service are active
    function activeSummaDomain(){
            $temp = $this->connect->prepare("SELECT domain,accountid FROM `telco_domains` WHERE call_anylises='1' AND domain NOT LIKE '%summa%'");
            $temp->execute();
            if($temp->rowCount()){
                 return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                 return die;
            }
    }
    
//    //last date tiem of summa call details
//    function lastSummaCallDetailsTimeDate(){
//            $temp = $this->connect->prepare("SELECT DATE_SUB(dt, INTERVAL 3 HOUR) FROM `summa_call_reports` ORDER BY id DESC LIMIT 1");
//            $temp->execute($data);
//            if($temp->rowCount()){
//                 return $temp->fetchColumn();
//            }else{
//                 return "2023-10-04 10:00:00";
//                 //return date("Y-m-d H:i:s");
//            }
//    }

	// Last date time of Summa call details
	function lastSummaCallDetailsTimeDate(){
	    // Prepare the SQL statement without requiring external parameters
	    $temp = $this->connect->prepare("SELECT DATE_SUB(dt, INTERVAL 3 HOUR) FROM `summa_call_reports` ORDER BY id DESC LIMIT 1");
	    
	    // Execute the prepared statement without passing the undefined $data variable
	    $temp->execute();
	    
	    // Check if the query returned any rows
	    if($temp->rowCount()){
	        // Return the result of the query
	        return $temp->fetchColumn();
	    } else {
	        // Return a default date-time value if no records are found
	        //return "2023-10-04 10:00:00"; // Or use date("Y-m-d H:i:s") for the current time
	        return date("Y-m-d H:i:s", strtotime("-6 hours"));

	    }
	}


//    //insert to summa call records
//     function insertCallSumma($data){
//        
//        $this->connect->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
//        
//        try{
//            
//            $this->connect->beginTransaction();
//            
//            
//            $temp = $this->connect->prepare("INSERT INTO `summa_call_reports`(`domain`, `cdr_id`, `orig_from_name`, `orig_to_user`, `orig_req_user`, `duration`, `time_start`, `orig_callid`, `term_callid`,`term_sub`, `release_text`,`response`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
//            
//            foreach($data as $item){
//                
//                //check call already exist
//                $temp2 = $this->connect->prepare("SELECT cdr_id FROM `summa_call_reports` WHERE cdr_id = ?");
//                $temp2->execute(array($item[1]));
//    
//                if($temp2->rowCount()){
//                     //DONT EXECUTE THE AND INSERT 
//                }else{
//                   $temp->execute($item);
//                }
//            }
//            
//            if($temp->rowCount()){
//                 $result = "Inserted";
//            }else{
//                 $result = "Fail";
//            }
//            
//            $this->connect->commit();
//            return $result;
//        }catch(PDOException $e){
//            echo $e->getMessage();
//            $this->connect->rollBack();
//            return "Fail2";
//        }
//    } 
    //
    //
    //
    //
    //

	function insertCallSumma($data){
	    $this->connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	    $insertedCount = 0;
	    $duplicateCount = 0;
	
	    try {
	        $this->connect->beginTransaction();
	
	        $temp = $this->connect->prepare("INSERT INTO `summa_call_reports` (domain, cdr_id, orig_from_name, orig_to_user, orig_req_user, duration, time_start, orig_callid, term_callid, release_text, term_sub, audio, audio_chunk, step, udt, try, response, fav) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
	
	        foreach($data as $item) {
	            // Ensure $item is correctly structured to match the prepared statement
	            $temp2 = $this->connect->prepare("SELECT cdr_id FROM `summa_call_reports` WHERE cdr_id = ?");
	            $temp2->execute([$item[1]]);
	
	            if(!$temp2->rowCount()) {
	                $temp->execute($item);
	                if($temp->rowCount()) $insertedCount++;
	            } else {
	                $duplicateCount++;
	            }
	        }
	
	        $this->connect->commit();
	
	        if($insertedCount > 0) {
	            return "Inserted $insertedCount records, $duplicateCount duplicates found.";
	        } else {
	            return "No new records inserted. $duplicateCount duplicates found.";
	        }
	    } catch (PDOException $e) {
	        $this->connect->rollBack();
	        error_log("Database insertion error: " . $e->getMessage());
	        throw new Exception("Error: Insertion failed. " . $e->getMessage());
	    }
	}



//    function insertCallSumma($data){
//	    $this->connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
//	    $insertedCount = 0;
//	    $duplicateCount = 0;
//	
//	    try {
//	        $this->connect->beginTransaction();
//	
//	        $temp = $this->connect->prepare("INSERT INTO `summa_call_reports`(...) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
//	
//	        foreach($data as $item) {
//	            $temp2 = $this->connect->prepare("SELECT cdr_id FROM `summa_call_reports` WHERE cdr_id = ?");
//	            $temp2->execute([$item[1]]);
//	
//	            if(!$temp2->rowCount()) {
//	                $temp->execute($item);
//	                if($temp->rowCount()) $insertedCount++;
//	            } else {
//	                $duplicateCount++;
//	            }
//	        }
//	
//	        $this->connect->commit();
//	
//	        if($insertedCount > 0) {
//	            return "Inserted $insertedCount records, $duplicateCount duplicates found.";
//	        } else {
//	            return "No new records inserted. $duplicateCount duplicates found.";
//	        }
//	    } catch (PDOException $e) {
//		    $this->connect->rollBack();
//		    error_log("Database insertion error: " . $e->getMessage()); // Use PHP's error_log() for simplicity
//		    throw new Exception("Error: Insertion failed. " . $e->getMessage()); // Optionally re-throw or handle as needed
//		}
//
//	    //} catch (PDOException $e) {
//	    //    $this->connect->rollBack();
//	    //    // Consider logging this error instead of echoing
//	    //    //logError($e->getMessage()); // Assume logError is a function you've defined for logging
//	    //    return "Error: Insertion failed.";
//	    //}
//	}

//	function logError($message) {
//	    $logFile = '/tmp/log_query.log';
//	    $timestamp = date('Y-m-d H:i:s');
//	    $logMessage = "{$timestamp} - ERROR: {$message}\n";
//	    file_put_contents($logFile, $logMessage, FILE_APPEND);
//	}
    
    
     //insert to summa call records//manual upload
     function insertCallSummaManual($data){
        
        $this->connect->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
       // $this->connect->setAttribute(PDO::ATTR_AUTOCOMMIT, 1);
        
        try{
            
            $this->connect->beginTransaction();
            
            
            $temp = $this->connect->prepare("INSERT INTO `summa_call_reports`(`domain`, `cdr_id`, `orig_from_name`, `orig_to_user`, `orig_req_user`, `duration`, `time_start`, `audio`, `audio_chunk`, `udt`, `term_callid`,`release_text`,`step`,`response`,`term_sub`) VALUES (?,?,?,?,?,?,?,?,?,now(),?,'Manual',1,?,?)");
            
            //check call already exist
                $temp2 = $this->connect->prepare("SELECT cdr_id FROM `summa_call_reports` WHERE cdr_id = ?");
                $temp2->execute(array($data[1]));
    
                if($temp2->rowCount()){
                     //DONT EXECUTE THE AND INSERT 
                }else{
                   $temp->execute($data);
                }
            
            
            if($temp->rowCount()){
                 $result = "Inserted";
            }else{
                 $result = "Fail";
            }
            
            //$temp->closeCursor();
            //$temp2->closeCursor();
            
            $this->connect->commit();
            return $result;
        }catch(PDOException $e){
            $this->connect->rollBack();
            echo $e->getMessage();
            return "Fail2";
        }
    } 
    
    
    //insert to summa call records//manual upload
     function selectUserUsingEmail($data){
            
        try{
            
            $temp = $this->connect->prepare("SELECT domain,term_sub FROM `summa_domain_settings` WHERE domain = ? AND term_sub = ? AND id = ?");
            $temp->execute($data);
            
            if($temp->rowCount()){
                return $temp->fetch(PDO::FETCH_ASSOC);
            }else{
                return 0;
            }
            
        }catch(PDOException $e){
            echo $e->getMessage();
            return "Fail2";
        }
    } 
    
    
    //fetch domain details for recording
    function summaCallDetailsForRecordingFetch(){
            $temp = $this->connect->prepare("SELECT summa_call_reports.cdr_id,summa_call_reports.domain,summa_call_reports.orig_callid, summa_call_reports.term_callid,telco_domains.accountid FROM `summa_call_reports` JOIN `summa_domain_settings` ON summa_domain_settings.domain = summa_call_reports.domain AND summa_call_reports.term_sub = summa_domain_settings.term_sub JOIN telco_domains ON summa_call_reports.domain = telco_domains.domain WHERE summa_call_reports.try < 10 AND summa_call_reports.duration > 0 AND telco_domains.call_anylises = 1 AND summa_call_reports.step=0 AND ADDTIME(COALESCE(summa_call_reports.udt,summa_call_reports.dt),'00:05:00') < NOW() ORDER BY summa_call_reports.id ASC LIMIT 5;");
            $temp->execute();
            if($temp->rowCount()){ 
                return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                 return array();
            }
    }
    
    function summaCallDetailsForRecordingFetchUpdateUdt($cdrid){
            $temp = $this->connect->prepare("UPDATE `summa_call_reports` SET udt = NOW() WHERE cdr_id = ?");
            $temp->execute([$cdrid]);
            if($temp->rowCount()){ 
                //return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                // return array();
                die("call date not updated");
            }
    }
    
    //fetch cdr data by domain & cdr_id
    function summaCallDetailsFetch($data){
            $temp = $this->connect->prepare("SELECT summa_call_reports.cdr_id,summa_call_reports.audio_chunk,summa_call_reports.audio,summa_call_reports.term_callid as audioName, summa_call_reports.release_text FROM `summa_call_reports` JOIN telco_domains ON telco_domains.domain = summa_call_reports.domain WHERE summa_call_reports.step=1 AND summa_call_reports.cdr_id =? AND summa_call_reports.domain = ?");
            $temp->execute($data);
            if($temp->rowCount()){
                 return $temp->fetch(PDO::FETCH_ASSOC);
            }else{
                 return array("success"=>false,"message"=>"No CDR ID found");
            }
    }
    
    /**insert transcript directly**/
    function insertSummaCallTranscriptDirect($data,$transcript){
        
        $this->connect->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
        
        try{
            
            $this->connect->beginTransaction();
            
            $temp = $temp = $this->connect->prepare("INSERT INTO `summa_call_reports`(`domain`, `cdr_id`, `orig_from_name`, `orig_to_user`, `orig_req_user`, `duration`, `time_start`, `audio`, `audio_chunk`,`term_callid`,`response`,`release_text`,`step`,`udt`,`term_sub`) VALUES (?,?,?,?,?,?,?,?,?,?,?,'Manual',2,now(),?)");
            
            //print_r($data);
            $temp->execute($data);
             
            $temp2 = $this->connect->prepare("INSERT INTO `summa_call_anylises`(`cdr_id`, `transcription`) VALUES (?,?)");
            $temp2->execute([$data[1],$transcript]);
            if($temp2->rowCount()){
                 $result = "Inserted";
            }else{
                 $result = "Fail";
            }
            
            $this->connect->commit();
            return $result;
        }catch(PDOException $e){
            echo $e;
            $this->connect->rollBack();
        }
    }
    
    
    /**update recording/transcript/summary**/
    function insertSummaCallTranscript($data){
        
        $this->connect->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
        
        try{
            
            $this->connect->beginTransaction();
            
            $temp = $this->connect->prepare("UPDATE `summa_call_reports` SET `step`=2,`response`=? WHERE cdr_id = ?");
            $temp->execute([$data[2],$data[0]]);
             
            $temp2 = $this->connect->prepare("INSERT INTO `summa_call_anylises`(`cdr_id`, `transcription`) VALUES (?,?)");
            $temp2->execute([$data[0],$data[1]]);
            if($temp2->rowCount()){
                 $result = array("success"=>true,"message"=>"Call Transcripted");
            }else{
                 $result = array("success"=>true,"message"=>"Call Transcripted not inserted");
            }
            
            $this->connect->commit();
            return $result;
        }catch(PDOException $e){
            return 0;
            //echo $e;
            $this->connect->rollBack();
        }
    }
    
    
    //fetch cdr data by domain & cdr_id
    function summaCallDetailsFetchForSummary($data){
            $temp = $this->connect->prepare("SELECT summa_call_reports.cdr_id,summa_call_reports.orig_from_name,summa_call_reports.dt,summa_call_reports.orig_req_user,summa_call_reports.duration,summa_call_reports.release_text,summa_call_reports.audio,summa_call_anylises.transcription,summa_domain_settings.gpt_prompt,summa_domain_settings.email,summa_domain_settings.email_temp,summa_domain_settings.audioLink,summa_domain_settings.appToken,summa_domain_settings.url FROM `summa_call_reports` JOIN telco_domains ON telco_domains.domain = summa_call_reports.domain JOIN summa_call_anylises ON summa_call_anylises.cdr_id = summa_call_reports.cdr_id JOIN summa_domain_settings ON summa_domain_settings.domain = summa_call_reports.domain AND summa_domain_settings.term_sub=summa_call_reports.term_sub WHERE summa_call_reports.step=2 AND summa_call_reports.cdr_id =? AND summa_call_reports.domain = ? AND summa_call_reports.term_sub = ?");
            $temp->execute($data);
            if($temp->rowCount()){
                
                 return array("success"=>true,"message"=>$temp->fetch(PDO::FETCH_ASSOC));
            }else{
                //print_r($data);
                $temp = $this->connect->prepare("UPDATE summa_call_reports SET step = 1 WHERE summa_call_reports.cdr_id =? AND summa_call_reports.domain = ? AND summa_call_reports.term_sub = ?");
                $temp->execute($data);
                
                 return array("success"=>false,"message"=>"No Transcription found!. Try to Transcript again.");
            }
    }
    
    /**update /summary**/
    function insertSummaCallSummary($data){
        
        $this->connect->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
        
        try{
            
            $this->connect->beginTransaction();
            
            $temp = $this->connect->prepare("UPDATE `summa_call_reports` SET `step`=3,`response`=? WHERE cdr_id = ?");
            $temp->execute([$data[2],$data[0]]);
             
            $temp2 = $this->connect->prepare("UPDATE `summa_call_anylises`SET summary=? WHERE cdr_id = ?");
            $temp2->execute([$data[1],$data[0]]);
            if($temp2->rowCount()){
                 $result = "Updated";
            }else{
                 $result = "Fail";
            }
            
            $this->connect->commit();
            return $result;
        }catch(PDOException $e){
            $this->connect->rollBack();
             return $e;
        }
    }
    
    /**update recording/transcript/summary**/
    function updateSummaCallReportDetails($data){
        
        $this->connect->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
        
        try{
            
            $this->connect->beginTransaction();
            
            $temp = $this->connect->prepare("UPDATE `summa_call_reports` SET `audio`=COALESCE(?,audio),`audio_chunk`=?,`step`=?,`udt`=NOW(),`try`=try+1,`response`=? WHERE cdr_id = ?");
            $temp->execute($data);
            if($temp->rowCount()){
                 $result = "Inserted";
            }else{
                 $result = "Fail";
            }
            
            $this->connect->commit();
            return $result;
        }catch(PDOException $e){
            echo $e;
            $this->connect->rollBack();
            return "Fail2";
        }
    } 
    
    //step update
    function updateSummaStep($data){
        
        $this->connect->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
        
        try{
            
            $this->connect->beginTransaction();
            
            $temp = $this->connect->prepare("UPDATE `summa_call_reports` SET `step`=? WHERE cdr_id = ?");
            $temp->execute($data);
             
            if($temp->rowCount()){
                 $result = 1;
            }else{
                 $result = 0;
            }
            
            $this->connect->commit();
            return $result;
        }catch(PDOException $e){
            $this->connect->rollBack();
            return 0;
        }
    }
    
    
    /**activate summa services**/
    function activateSummaServices($data){
        
        $this->connect->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
        
        try{
            
            $this->connect->beginTransaction();
            
            $temp = $this->connect->prepare("UPDATE `telco_domains` SET call_anylises = '1' WHERE domain = ?");
            $temp->execute([$data[0]]);
             
            $temp2 = $this->connect->prepare("INSERT INTO `summa_domain_settings`(`domain`, `p_recording`, `p_transcription`, `p_summary`, `email`, `url`, `gpt_prompt`,`term_sub`) VALUES (?,?,?,?,?,?,?,?)");
            $temp2->execute($data);
            if($temp2->rowCount()){
                 $result = array("success"=>true,"data"=>"Service Activated!");
            }else{
                 $result = array("success"=>false,"message"=>"Something went wrong");
            }
            
            $this->connect->commit();
            return $result;
        }catch(PDOException $e){
            $this->connect->rollBack();
            return $e->getMessage();
        }
    }
    
    
    /**unsubscribe summa services**/
    function deactivateSummaServices($data){
        
        $this->connect->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
        
        try{
            
            $this->connect->beginTransaction();
            
            // $temp = $this->connect->prepare("UPDATE `telco_domains` SET call_anylises = '0' WHERE domain = ?");
            // $temp->execute($data);
             
            $temp2 = $this->connect->prepare("DELETE FROM `summa_domain_settings` WHERE id = ?");
            $temp2->execute($data);
            if($temp2->rowCount()){
                 $result = array("success"=>true,"data"=>"Service Deactivated!");
            }else{
                 $result = array("success"=>false,"message"=>"Something went wrong");
            }
            
            $this->connect->commit();
            return $result;
        }catch(PDOException $e){
            $this->connect->rollBack();
            return $e->getMessage();
        }
    }
    
    /**active summa prompt/service**/
    function detailedActiveSummaServices($data){
        
            $temp2 = $this->connect->prepare("SELECT * FROM `summa_domain_settings` WHERE  id = ?");
            $temp2->execute($data);
            if($temp2->rowCount()){
                 return array("success"=>true,"data"=>$temp2->fetch(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"Something went wrong");
            }
            
    }
    
    /**update summa service**/
    function updateActiveSummaServices($data){
        
            $temp2 = $this->connect->prepare("UPDATE `summa_domain_settings` SET `p_recording` = ?, `p_transcription` =?, `p_summary` =?, `email`= ?, `url` = ?, `gpt_prompt` = ?,`url` = ?,`term_sub` =? WHERE id= ?");
            $temp2->execute($data);
            if($temp2->rowCount()){
                 return array("success"=>true);
            }else{
                 return array("success"=>false,"message"=>"Something went wrong");
            }
            
    }
    
    /**get token of user by domain & term sub**/
    function getSummaServicesToken($data){
        
            $temp2 = $this->connect->prepare("SELECT `token` FROM `token_validator` WHERE domain = ? AND term_sub = ? ORDER BY id DESC LIMIT 1");
            $temp2->execute($data);
            if($temp2->rowCount()){
                 return array("success"=>true,"data"=>$temp2->fetch(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"Something went wrong");
            }
            
    }
    
    /**update summa service by user**/
     function updateActiveSummaServicesByUser($data){
        
            $temp2 = $this->connect->prepare("UPDATE `summa_domain_settings` SET `email_temp`= COALESCE(?,email_temp) ,`audioLink`= COALESCE(?,audioLink) WHERE domain = ? AND term_sub = ?");
            $temp2->execute($data);
            if($temp2->rowCount()){
                 return array("success"=>true);
            }else{
                 return array("success"=>false,"message"=>"Something went wrong");
            }
            
    }
    
    
    /**update summa service by app token user**/
     function updateAppTokenSummaServicesByUser($data){
        
            $temp2 = $this->connect->prepare("UPDATE `summa_domain_settings` SET  `appToken` = COALESCE(?,appToken) WHERE domain = ? AND term_sub = ?");
            $temp2->execute($data);
            if($temp2->rowCount()){
                 return array("success"=>true);
            }else{
                 return array("success"=>false,"message"=>"Something went wrong");
            }
            
    }
    
     /**update summa service**/
    function activeSummaServicesList(){
        
            $temp2 = $this->connect->prepare("SELECT summa_domain_settings.id AS sid,telco_domains.id,CONCAT(telco_domains.domain,'--',summa_domain_settings.term_sub) AS name,telco_domains.domain,telco_domains.accountid,telco_domains.call_anylises FROM telco_domains JOIN summa_domain_settings ON summa_domain_settings.domain = telco_domains.domain");
            $temp2->execute();
            if($temp2->rowCount()){
                 return array("success"=>true,"data"=>$temp2->fetchAll(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"Something went wrong");
            }
            
    }
    
    //insert to summa call records
     function updateUserSettings($data){
        
        $this->connect->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
        
        try{
            
            $this->connect->beginTransaction();
            
            
            $temp = $this->connect->prepare("INSERT INTO `summa_call_reports`(`domain`, `cdr_id`, `orig_from_name`, `orig_to_user`, `orig_req_user`, `duration`, `time_start`, `orig_callid`, `term_callid`,`term_sub`, `release_text`,`response`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
            
            foreach($data as $item){
                
                //check call already exist
                $temp2 = $this->connect->prepare("SELECT cdr_id FROM `summa_call_reports` WHERE cdr_id = ?");
                $temp2->execute(array($item[1]));
    
                if($temp2->rowCount()){
                     //DONT EXECUTE THE AND INSERT 
                }else{
                   $temp->execute($item);
                }
            }
            
            if($temp->rowCount()){
                 $result = "Inserted";
            }else{
                 $result = "Fail";
            }
            
            $this->connect->commit();
            return $result;
        }catch(PDOException $e){
            echo $e->getMessage();
            $this->connect->rollBack();
            return "Fail2";
        }
    } 
    
    //fetch email settings
    function getSummaSettings($data){
        //print_r($data);
            $temp2 = $this->connect->prepare("SELECT * FROM `summa_domain_settings` WHERE domain = ? AND term_sub = ?");
            $temp2->execute($data);
            if($temp2->rowCount()){
                 return array("success"=>true,"data"=>$temp2->fetch(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"Something went wrong");
            }
            
    }
    
    
    /**End**/
    
    /**call notification**/
     function insertCallNotificationDetails($data){
        
        $this->connect->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
        
        try{
            
            $this->connect->beginTransaction();
            
            //check call already exist
            $temp = $this->connect->prepare("SELECT id FROM `call_notifications` WHERE term_domain = ? AND orig_callid = ? AND term_callid = ?");
            $temp->execute(array($data[0],$data[4],$data[5]));

            if($temp->rowCount()){
                 return "Exist";//if exist
            }
            
            $temp = $this->connect->prepare("INSERT INTO `call_notifications` (`term_domain`, `orig_from_name`, `orig_from_user`, `orig_to_user`, `orig_callid`, `term_callid`) VALUES (?,?,?,?,?,?)");
            $temp->execute($data);
            if($temp->rowCount()){
                 $result = "Inserted";
            }else{
                 $result = "Fail";
            }
            
            $this->connect->commit();
            return $result;
        }catch(PDOException $e){
            echo $e;
            $this->connect->rollBack();
            return "Fail2";
        }
    } 
    /**end**/
    
    /**ccall report**/
    
    function subsCallForRecordingRequest($data){
            $temp = $this->connect->prepare("INSERT INTO `domain_contacts_profile`(`domain_id`, `email`,`gpt_prompt`,`token`) VALUES (?,?,?,'0')");
            $temp->execute($data);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>"done");
            }else{
                 return array("success"=>false,"message"=>"something wents wrong");
            }
    } 
    
    function selectCallDetailsForRecordingSend($id){
            $temp = $this->connect->prepare("SELECT email,gpt_prompt FROM `domain_contacts_profile` JOIN telco_domains ON telco_domains.id = domain_contacts_profile.domain_id WHERE telco_domains.domain =? ORDER BY domain_contacts_profile.id DESC LIMIT 1;");
            $temp->execute([$id]);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetch(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"Unable to fetch details");
            }
    } 
    
    
    function selectCallDetailsForRecordingRequest(){
            $temp = $this->connect->prepare("SELECT call_reports.term_domain,call_reports.orig_callid,call_reports.term_callid,telco_domains.accountid FROM `call_reports` JOIN `telco_domains` ON call_reports.term_domain = telco_domains.domain WHERE call_reports.audio IS NULL AND telco_domains.call_anylises = '1' AND ADDTIME(udt,'00:05:00') < NOW() AND try < 10");
            $temp->execute($data);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetchAll(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"Unable to fetch details");
            }
    } 
    
    
     function selectCallDetailsContact($data){
            $temp = $this->connect->prepare("SELECT id FROM `call_reports` WHERE term_domain = ? AND orig_callid = ? AND term_callid = ?");
            $temp->execute($data);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetch(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"Unable to fetch details");
            }
    }  
    
    
     function updateCallDetailsContact($data){
         
          $this->connect->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
        
        try{
            
            $this->connect->beginTransaction();
            
            $temp = $this->connect->prepare("UPDATE `call_reports` SET `duration`=COALESCE(?,duration),`audio`=COALESCE(?,audio),`summary`=COALESCE(?,summary),`response`=COALESCE(?,response),`try` = (try+1),`udt`=now() WHERE term_domain = ? AND orig_callid = ? AND term_callid = ?");
            $temp->execute($data);
            if($temp->rowCount()){
                 $result = array("success"=>true,"data"=>"Updated");
            }else{
                 $result = array("success"=>false,"message"=>"fail");
            }
            
               
        $this->connect->commit();
            return $result;
        }catch(PDOException $e){
            
            $this->connect->rollBack();
            return array("success"=>false,"message"=>"fail");
        }
    }   
    
    
    
    function insertCallDetailsContact($data){
        
        $this->connect->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
        
        try{
            
            $this->connect->beginTransaction();
            
            //check call already exist
            $temp = $this->connect->prepare("SELECT id FROM `call_reports` WHERE term_domain = ? AND orig_callid = ? AND term_callid = ?");
            $temp->execute(array($data[0],$data[4],$data[5]));

            if($temp->rowCount()){
                 return;//if exist
            }
            
            $temp = $this->connect->prepare("INSERT INTO `call_reports`(`term_domain`, `orig_from_name`, `orig_from_user`, `orig_to_user`, `orig_callid`, `term_callid`, `time_start`,`response`,`udt`) VALUES (?,?,?,?,?,?,?,?,now())");
            $temp->execute($data);
            if($temp->rowCount()){
                 $result = array("success"=>true,"data"=> $this->connect->lastInsertId());
            }else{
                 $result = array("success"=>false,"message"=>"fail");
            }
            
            $this->connect->commit();
            return $result;
        }catch(PDOException $e){
            
            $this->connect->rollBack();
            return array("success"=>false,"message"=>"fail");
        }
    } 
    
     function insertCallDetailsText($data){
            $temp = $this->connect->prepare("INSERT INTO `call_to_text`(`call_report_id`, `call_text`, `summary`) VALUES (?,?,?)");
            $temp->execute($data);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>"inserted");
            }else{
                 return array("success"=>false,"message"=>"fail");
            }
    } 
    
    // note for Akeed: Analysis is the correct spelling 
    function selectCallRecordingForAnylises(){
            $temp = $this->connect->prepare("SELECT id,CONCAT(orig_callid,term_callid,'.wav') as file,term_domain,orig_callid,term_callid,orig_from_name,orig_from_user,duration,audio  FROM `call_reports` WHERE summary = '' AND audio IS NOT NULL");
            $temp->execute();
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetchAll(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"Unable to fetch details");
            }
    } 
   
    
    
    function selectCallDetailsByPhone($data){
            $temp = $this->connect->prepare("SELECT summa_call_reports.time_start,summa_call_reports.duration,summa_call_reports.audio,summa_call_reports.udt,summa_call_reports.try,summa_call_anylises.summary FROM `summa_call_reports` JOIN `summa_call_anylises` ON summa_call_anylises.cdr_id = summa_call_reports.cdr_id WHERE domain=? AND summa_call_reports.orig_req_user=?  ORDER BY summa_call_reports.id DESC LIMIT 1");
            $temp->execute($data);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetch(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"No records found!");
            }
    } 
    
    function selectActivePrompt($data){
            $temp = $this->connect->prepare("SELECT * FROM `domain_contacts_profile` WHERE domain_id = ? ORDER BY id DESC LIMIT 1");
            $temp->execute($data);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetch(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"No records found!");
            }
    } 
    
    
     /**end**/
    /**rev_io*/
    
    function selectRevIoContact($search){
            $temp = $this->connect->prepare("SELECT * FROM rev_io_contacts WHERE rev_id = :search || SUBSTRING(mobile,-10) = SUBSTRING(:search,-10) || SUBSTRING(phone,-10) = SUBSTRING(:search,-10) || email = :search");
            $temp->execute(array(':search'=>$search));
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetch(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"Unable to fetch details");
            }
    }  
    
    /**find by revid**/
     function selectRevIoId($search){
            $temp = $this->connect->prepare("SELECT * FROM rev_io_contacts WHERE contact_id = :search");
            $temp->execute(array(':search'=>$search));
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetch(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"Unable to fetch details");
            }
    }  
    
    
     function updateRevIoContact($data){
            $temp = $this->connect->prepare("UPDATE `rev_io_contacts` SET `mobile`=COALESCE(:mob,mobile),`phone`=COALESCE(:ph,phone),`email`=COALESCE(:email,email),`contact_id`=COALESCE(:contact_id,contact_id), `dt` = now() WHERE contact_id = :custid");
            $temp->execute($data);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>"Updated");
            }else{
                 return array("success"=>false,"message"=>"fail");
            }
    }   
    
    
    
    function insertRevIoContact($data){
            $temp = $this->connect->prepare("INSERT INTO `rev_io_contacts`(`rev_id`, `mobile`, `phone`, `email`, `contact_id`) VALUES (:custid, :mob ,:ph , :email,:contact_id)");
            $temp->execute($data);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>"Updated");
            }else{
                 return array("success"=>false,"message"=>"fail");
            }
    }    
    
    
    
    //**insert in database*/
    //caller details
     function company_details_by_phonenumber_caller($number){
            $temp = $this->connect->prepare("SELECT * FROM telco_domains WHERE id = (SELECT domain_id FROM `telco_domain_phone_numbers` where SUBSTRING(phone_number,-10) = SUBSTRING(?,-10) order by id desc LIMIT 1);");
            $temp->execute([$number]);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetch(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"Unable to fetch details");
            }
    }   
    
    
     //create zoleo request
    function submit_ivr_messages($data){

            $temp = $this->connect->prepare("INSERT INTO `ivr_sms`(`sendAs`, `user`, `aid`, `key_sms`, `forward`, `message`, `domain`) VALUES (?,?,?,?,?,?,?)");
            $temp->execute($data);
            if($temp->rowCount()){
                 return $this->connect->lastInsertId();
            }else{
                 return array("success"=>false,"message"=>"Something Wents wrong");
            }
    }
    
    //get messages
    function get_ivr_messages($data){

            $temp = $this->connect->prepare("SELECT * FROM `ivr_sms` WHERE domain = ?");
            $temp->execute([$data]);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetchAll(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"No messages");
            }
    }
    
     //get messages by key + domain
    function get_ivr_messages_by_key($data){

            $temp = $this->connect->prepare("SELECT * FROM `ivr_sms` WHERE domain = ? AND key_sms = ?");
            $temp->execute($data);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetch(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"No messages");
            }
    }
    //delete
    function delete_ivr_messages($data){

            $temp = $this->connect->prepare("DELETE FROM `ivr_sms` WHERE id = ?");
            $temp->execute([$data]);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>"Successfully deleted!");
            }else{
                 return array("success"=>false,"message"=>"Something Wents wrong");
            }
    }
    
    //update messages
    function update_ivr_messages($data){

            $temp = $this->connect->prepare("UPDATE `ivr_sms` SET `sendAs`=COALESCE(?,sendAs),`key_sms`=COALESCE(?,key_sms),`forward`=COALESCE(?,forward),`message`=COALESCE(?,message) WHERE id = ?");
            $temp->execute($data);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>"Successfully deleted!");
            }else{
                 return array("success"=>false,"data"=>"Something Wents wrong");
            }
    }
    
    /**zoleo**/
    //company details by phone no.
     function company_details_by_phonenumber($token){

            $phone = $this->phonenumber_by_token($token);
            $temp = $this->connect->prepare("SELECT * FROM telco_domains WHERE id = (SELECT domain_id FROM `telco_domain_phone_numbers` where SUBSTRING(phone_number,-10) = SUBSTRING(?,-10) order by id desc LIMIT 1);");
            $temp->execute([$phone]);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetch(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"Unable to fetch details");
            }
    }   
    
    //set otp
    function insert_otp_by_phonenumber($data){
            if($this->company_details_by_phonenumber($data[0])!==0){
                
                $temp = $this->connect->prepare("INSERT INTO `otp_login`(`phone_number`, `otp`, `token`) VALUES (?,?,'NA')");
                $temp->execute($data);
                return $temp->rowCount();
                
            }else{
                return "309 Phone number not found";
            }
    } 
    
    //generate token
     function insert_gen_token($data){
                $temp = $this->connect->prepare("UPDATE `otp_login` SET token=? WHERE id = ?");
                $temp->execute($data);
                return $temp->rowCount();
     } 
    
    //verify otp / generate token
    function login_by_phonenumber_otp($data){

            $temp = $this->connect->prepare("SELECT id FROM `otp_login` WHERE phone_number = ? AND otp= ? ORDER BY id DESC LIMIT 1");
            $temp->execute($data);
            if($temp->rowCount()){
                 $token = base64_encode(rand(000000,999999)).base64_encode(rand(000000,999999));
                 $gt = array($token,$temp->fetchColumn());
                 if($this->insert_gen_token($gt)){
                     $cn = $this->company_details_by_phonenumber($token)['data']['domain'];
                     $status = $this->status_zoleo_request($cn);
                     if($status['success']==true){
                         $pg = $status['data']['status'] == "PENDING" ? 2 : 3;
                     }else{
                         $pg = 1;
                     }
                     return array("success"=>true,"token"=>$token,"pg"=>$pg);
                 }else{
                     return array("success"=>false,"message"=>"Unable to generate token");
                 }
            }else{
                return array("success"=>false,"message"=>"Invalid Login!");
            }
    }  
    
    
    //get phone number by token
    function phonenumber_by_token($token){

            $temp = $this->connect->prepare("SELECT phone_number FROM `otp_login` WHERE token = ?");
            $temp->execute([$token]);
            if($temp->rowCount()){
                 return $temp->fetchColumn();
            }else{
                 return array("success"=>false,"message"=>"Invalid Token!");
            }
    }
    
    
    //create zoleo request
    function submit_zoleo_request($data){

            $temp = $this->connect->prepare("INSERT INTO `zoleo_config`(`domain`, `user`, `number`, `zeleo_email`, `status`) VALUES (?, ?, ?, ?, 'PENDING')");
            $temp->execute($data);
            if($temp->rowCount()){
                 return $this->connect->lastInsertId();
            }else{
                 return array("success"=>false,"message"=>"Something Wents wrong or zoleo email already exist!");
            }
    }
    
     //zoleo request status
    function status_zoleo_request($domain){

            $temp = $this->connect->prepare("SELECT * FROM `zoleo_config` WHERE domain = ?");
            $temp->execute([$domain]);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetch(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"No Records");
            }
    }
    
     //zoleo request
    function get_zoleo_request(){

            $temp = $this->connect->prepare("SELECT * FROM `zoleo_config`");
            $temp->execute();
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetchAll(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"No Records");
            }
    }
    //ZOLEO UPDATE
     function update_zoleo_request($data){

            $temp = $this->connect->prepare("UPDATE `zoleo_config` SET status = COALESCE(?,status) , our_email = COALESCE(?,our_email) WHERE id = ?");
            $temp->execute($data);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>"Updated Successfully.");
            }else{
                 return array("success"=>false,"data"=>"Something wents wrong!");
            }
    }
    
     //zoleo mail filter//receiver
    function zoleo_mail_filter($email){

            $temp = $this->connect->prepare("SELECT * FROM `zoleo_config` WHERE our_email = ?");
            $temp->execute([$email]);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetch(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"Spam");
            }
    }
    
    //zoleo no filter//sender
    function zoleo_reveiver_filter($email){

            $temp = $this->connect->prepare("SELECT * FROM `zoleo_config` WHERE zeleo_email = ?");
            $temp->execute([$email]);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetch(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>false,"message"=>"Spam");
            }
    }
    //complay details by ph.
    function company_details_by_phonenumber_notoken($phone){
            $temp = $this->connect->prepare("SELECT * FROM telco_domains WHERE id = (SELECT domain_id FROM `telco_domain_phone_numbers` where SUBSTRING(phone_number,-10) = SUBSTRING(?,-10) order by id desc LIMIT 1);");
            $temp->execute([$phone]);
            if($temp->rowCount()){
                 return $temp->fetch(PDO::FETCH_ASSOC);
            }else{
                 return ;
            }
    } 
    /**zoleo messaging**/
    //from messages
    function message_by_user($domain){
            $temp = $this->connect->prepare("SELECT DISTINCT from_no,to_no,user_id FROM `zoleo_messages` WHERE user_id=(SELECT id FROM `zoleo_config` WHERE domain = ?) ORDER BY id DESC");
            $temp->execute([$domain]);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetchAll(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>true,"message"=>"No messages found");
            }
    } 
    
    //DETAILEDMESSAGE
    function message_by_details($data){
            $temp = $this->connect->prepare("SELECT message,sender FROM `zoleo_messages` WHERE user_id=(SELECT id FROM `zoleo_config` WHERE domain = ?) AND from_no = ? ORDER BY id DESC LIMIT 50");
            $temp->execute($data);
            if($temp->rowCount()){
                 return array("success"=>true,"data"=>$temp->fetchAll(PDO::FETCH_ASSOC));
            }else{
                 return array("success"=>true,"message"=>"No messages details found");
            }
    } 
    
    
    //DETAILEDMESSAGE
    function message_insert($data){
            $temp = $this->connect->prepare("INSERT INTO `zoleo_messages`(`user_id`, `from_no`, `to_no`, `message`, `sender`) VALUES (?, ?, ?, ?, ?)");
            $temp->execute($data);
            if($temp->rowCount()){
                 return "Success";
            }else{
                 return "false";
            }
    } 
    
    /**end zoleo**/

   //**email extractor */
    function email_insert($email){

            $temp = $this->connect->prepare("INSERT IGNORE INTO `emails`(`email`,`user`)VALUES(:email,:user)");
            $temp->execute($email);
    }
    
    
     //**email extractor */
    function email_update($email){

            $temp = $this->connect->prepare("UPDATE `emails` SET sent = '1' WHERE email = ?");
            $temp->execute([$email]);
    }
    
     //**email extractor */
    function email_unscubscribe($email){

            $temp = $this->connect->prepare("UPDATE `emails` SET subs = '0' WHERE email = ?");
            $temp->execute([$email]);
            return $temp->rowCount();
    }
    
    //**email extractor */
    function email_select($user){

            $temp = $this->connect->prepare("SELECT email FROM `emails` WHERE sent = '0'  AND subs = '1' AND user = ?");
            $temp->execute([$user]);
            return $temp->fetchAll(PDO::FETCH_ASSOC);
    }
    
    //**email sent statistics */
    function email_select_statistics(){

            $temp = $this->connect->prepare("SELECT 'Sent' AS type ,COUNT(id) As total FROM emails WHERE sent = '1' AND subs = '1' UNION SELECT 'Pending' AS type,COUNT(id) As total  FROM emails WHERE sent = '0' AND subs = '1';");
            $temp->execute();
            return $temp->fetchAll(PDO::FETCH_ASSOC);
    }
    
 //**email extractor */
    function email_extractor(){

            $temp = $this->connect->prepare("SELECT * FROM `telco_subscribers` WHERE SUBSTRING(dt,1,10) = (SELECT SUBSTRING(dt,1,10) FROM `telco_subscribers` ORDER BY id DESC LIMIT 1)");
            $temp->execute();
            return $temp->fetchAll(PDO::FETCH_ASSOC);
            
    }

    //**telco domains */
    function telco_domain_insert($arrayData){
        
        if($this->telco_domain_update($arrayData)>0){
          return;
        }else{

            $temp = $this->connect->prepare("INSERT INTO `telco_domains`(`domain`, `reseller`, `description`, `accountid`) VALUES (?,?,?,?)");
            $temp->execute($arrayData);
            if($this->connect->lastInsertId()){
                return 1;
            }else{
                return 0;
            }
       }
    }


    function telco_domain_update($arrayData){
        try{
            $this->connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $temp = $this->connect->prepare("UPDATE `telco_domains` SET `domain`=COALESCE(?, domain),`reseller`=COALESCE(?, reseller),`description`=COALESCE(?, description),`accountid`=COALESCE(?, accountid),dt=now() WHERE domain = ?");
            array_push($arrayData,$arrayData[0]);
            $temp->execute($arrayData);
            return $temp->rowCount();
        }catch(PDOException $e){
            echo $e->getMessage();
        }
    }
    
    function telco_domain_services($arrayData){
        try{
            $this->connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $temp = $this->connect->prepare("UPDATE `telco_domains` SET `call_anylises` = :callanylises WHERE id = :id");
            $temp->execute($arrayData);
            return $temp->rowCount();
        }catch(PDOException $e){
            echo $e->getMessage();
        }
    }
    
    function telco_domain_rev_ac_update($arrayData){
        try{
            $this->connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $temp = $this->connect->prepare("UPDATE `telco_domains` SET `rev_ac`=COALESCE(?, rev_ac),`com_percentage`=COALESCE(?, com_percentage) WHERE id = ?");
            $temp->execute($arrayData);
            return $temp->rowCount();
        }catch(PDOException $e){
            echo $e->getMessage();
        }
    }
    
    function telco_domain_rev_ac_update_with_domain($arrayData){
        try{
            $this->connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $temp = $this->connect->prepare("UPDATE `telco_domains` SET `rev_ac`=? WHERE domain = ?");
            $temp->execute($arrayData);
            return $temp->rowCount();
        }catch(PDOException $e){
            echo $e->getMessage();
        }
    }
    
    function telco_domain_pay($arrayData){
        try{
            $this->connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $temp = $this->connect->prepare("UPDATE `telco_domains` SET `paying`=? WHERE id = ?");
            $temp->execute($arrayData);
            return $temp->rowCount();
        }catch(PDOException $e){
            echo $e->getMessage();
        }
    }
    
    /**rev_bill_insert**/
    function rev_bill_insert($arrayData){
         $this->connect->beginTransaction();
         try{
            $this->connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $temp = $this->connect->prepare("INSERT INTO `rev_io_billing_file`(`acctnum`, `name`, `statement_id`, `mrc`, `nrc`, `usage_rev`, `occ`, `credits`, `tax`, `total`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            
            foreach($arrayData as $data){
                $temp->execute($data);
            }
            
            $this->connect->commit();
            return true;
        }catch(PDOException $e){
            $this->connect->rollBack();
            echo $e->getMessage();
        }
    }
    
    
    /**ss_bill_insert**/
    function ss_bill_insert($arrayData){
         $this->connect->beginTransaction();
         try{
            $this->connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $temp = $this->connect->prepare("INSERT INTO `ss_billing_file`(`domain`, `pbx_users`, `call_center`, `call_recording`, `sip_trunks`, `meeting_rooms`, `voicemail_transcription`, `telephone_numbers`, `ms_teams_connectors`, `video_connectors`) VALUES (?,?,?,?,?,?,?,?,?,?)");
            
            foreach($arrayData as $data){
                $temp->execute($data);
            }
            
            $this->connect->commit();
            return true;
        }catch(PDOException $e){
            $this->connect->rollBack();
            echo $e->getMessage();
        }
    }
    
    
    /**rev_ss_bill_insert_date**/
    function rev_ss_bill_insert_date(){
   
            $temp = $this->connect->prepare("SELECT DISTINCT(SUBSTRING(ss_billing_file.dt,1,10)) as date FROM `ss_billing_file` JOIN rev_io_billing_file ON SUBSTRING(ss_billing_file.dt,1,10)=SUBSTRING(rev_io_billing_file.dt,1,10) ORDER BY ss_billing_file.dt DESC");
            $temp->execute();
            $temp->execute();
            if($temp->rowCount()){
                return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                return 0;
            }
    }
    
     /**rev_ss_comprasion**/
    function rev_ss_bill_comprasion($date){
   
            $temp = $this->connect->prepare("SELECT DISTINCT telco_domains.domain,ss_billing_file.pbx_users,ss_billing_file.call_center,ss_billing_file.call_recording,ss_billing_file.sip_trunks,ss_billing_file.meeting_rooms,ss_billing_file.voicemail_transcription,ss_billing_file.telephone_numbers,ss_billing_file.ms_teams_connectors,ss_billing_file.video_connectors,TRUNCATE(msa_rates.pbx_users*ss_billing_file.pbx_users+msa_rates.call_center*ss_billing_file.call_center+msa_rates.call_recording*ss_billing_file.call_recording+msa_rates.sip_trunks*ss_billing_file.sip_trunks+msa_rates.meeting_rooms*ss_billing_file.meeting_rooms+msa_rates.voicemail_ranscription*ss_billing_file.voicemail_transcription+msa_rates.telephone_numbers*ss_billing_file.telephone_numbers+msa_rates.ms_teams_connectors*ss_billing_file.ms_teams_connectors+msa_rates.video_connectors*ss_billing_file.video_connectors,2) as ss_cost,rev_io_billing_file.acctnum,rev_io_billing_file.name,rev_io_billing_file.statement_id,rev_io_billing_file.mrc,rev_io_billing_file.nrc,rev_io_billing_file.usage_rev,rev_io_billing_file.occ,rev_io_billing_file.credits,rev_io_billing_file.tax,rev_io_billing_file.total FROM `rev_io_billing_file` JOIN telco_domains ON telco_domains.rev_ac = rev_io_billing_file.acctnum JOIN ss_billing_file ON ss_billing_file.domain=telco_domains.domain JOIN msa_rates  WHERE telco_domains.rev_ac!=0 AND SUBSTRING(ss_billing_file.dt,1,10)=?");
            $temp->execute([$date]);
             $temp->execute();
            if($temp->rowCount()){
                return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                return 0;
            }
    }
    
    
     /**insert vendor charges**/
    function vendor_charges_insert($arrayData){
         $this->connect->beginTransaction();
         try{
            $this->connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $temp = $this->connect->prepare("INSERT INTO `total_vendor_charges`(`total_usage_costs`, `total_regulatory_costs`) VALUES (?,?)");
                $temp->execute($arrayData);
            $this->connect->commit();
            return true;
        }catch(PDOException $e){
            $this->connect->rollBack();
            echo $e->getMessage();
        }
    }
    
     /**update vendor charges**/
    function vendor_charges_update($arrayData){
         $this->connect->beginTransaction();
         try{
            $this->connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $temp = $this->connect->prepare("UPDATE `total_vendor_charges` SET `total_usage_costs` = ?, `total_regulatory_costs` = ? WHERE  SUBSTRING(dt,1,10) = ?");
                $temp->execute($arrayData);
            $this->connect->commit();
            return true;
        }catch(PDOException $e){
            $this->connect->rollBack();
            echo $e->getMessage();
        }
    }
    
    /**commission calculate querys**/
    function get_commission($date){
   
            $temp = $this->connect->prepare("CALL `new_commission_calculator`(?)");
            $temp->execute([$date]);
            if($temp->rowCount()){
                return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                return 0;
            }
    }
    
    /**end commission querys**/
    
    
    /**get usage date**/
     function telco_get_usage_on_date($date){
   
            $temp = $this->connect->prepare("SELECT * FROM `total_vendor_charges` WHERE SUBSTRING(dt,1,10) = ?");
            $temp->execute($date);
            if($temp->rowCount()){
                return $temp->fetch(PDO::FETCH_ASSOC);
            }else{
                return 0;
            }
    }
    
    
     /**rev_ss_comprasion**/
    function telco_domain_select_no_rev_id($is_rev){
        
            if($is_rev==0){
                 $temp = $this->connect->prepare("SELECT * FROM `telco_domains` WHERE rev_ac!=0 & paying=1");
            }else{
                 $temp = $this->connect->prepare("SELECT * FROM `telco_domains` WHERE rev_ac=0");
            }
           
             $temp->execute();
            if($temp->rowCount()){
                return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                return 0;
            }
    }
    
     /**domain by customer id/rev_ac**/
    function telco_domain_select_by_rev_ac($custId){
        
            $temp = $this->connect->prepare("SELECT * FROM `telco_domains` WHERE rev_ac = ?");
            $temp->execute([$custId]);
            if($temp->rowCount()){
                return $temp->fetch(PDO::FETCH_ASSOC);
            }else{
                return "Contact Technical Staff";
            }
    }
    
     /**like with description**/
    function telco_domain_by_company_name($cname){
        
            $temp = $this->connect->prepare("SELECT * FROM `telco_domains` WHERE description LIKE ? AND rev_ac=0");
             $temp->execute(['%'.$cname.'%']);
            if($temp->rowCount()){
                return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                return 0;
            }
    }
    
    /**UPDATE**/
    function telco_domain_rev_ac_update_with_domain_ci($arrayData){
        try{
            $this->connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $temp = $this->connect->prepare("UPDATE `telco_domains` SET `rev_ac`=?,paying=3 WHERE id = ?");
            $temp->execute($arrayData);
            return $temp->rowCount();
        }catch(PDOException $e){
            echo $e->getMessage();
        }
    }
    
    /**commission date all table ss,rev,vendor charges**/
    function get_insert_date_commission(){
   
            $temp = $this->connect->prepare("SELECT DISTINCT(SUBSTRING(ss_billing_file.dt,1,10)) as date FROM `ss_billing_file` JOIN rev_io_billing_file ON SUBSTRING(ss_billing_file.dt,1,10)=SUBSTRING(rev_io_billing_file.dt,1,10) JOIN total_vendor_charges ON SUBSTRING(ss_billing_file.dt,1,10)=SUBSTRING(total_vendor_charges.dt,1,10) ORDER BY ss_billing_file.dt DESC");
            $temp->execute();
            if($temp->rowCount()){
                return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                return 0;
            }
    }
    
    
    
    /**EXCEPTION IN CSV**/
    function get_commission_exception($date){
   
            $temp = $this->connect->prepare("CALL `commission_csv_exception`(?)");
            $temp->execute([$date]);
            if($temp->rowCount()){
                return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                return 0;
            }
    }
   

    /**select domains */
    function telco_domain_select(){
        
            $temp = $this->connect->prepare("SELECT * FROM `telco_domains`");
            $temp->execute();
            if($temp->rowCount()){
                return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                return 0;
            }
      
    }

    /**insert phone numbers by domain wise */
    function telco_phone_numbers_domain_wise($arrayData){
            
        // if($this-> telco_phone_numbers_domain_wise_update($arrayData)>0){

        // }else{
            $temp = $this->connect->prepare("INSERT INTO `telco_domain_phone_numbers`(`domain_id`, `phone_number`) VALUES (?,?)");
            $temp->execute($arrayData);
            if($this->connect->lastInsertId()){
                return 1;
            }else{
                return 0;
            }
        //}        
    }

    function telco_phone_numbers_domain_wise_update($arrayData){
        try{
            $this->connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $temp = $this->connect->prepare("UPDATE `telco_domain_phone_numbers` SET `domain_id`=?,`dt`=now() WHERE `phone_number`=?");
            $temp->execute($arrayData);
            return $temp->rowCount();
        }catch(PDOException $e){
            echo $e->getMessage();
        }
    }
    
     function telco_phone_numbers_domain_wise_get($arrayData){
        try{
            $this->connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $temp = $this->connect->prepare("SELECT phone_number FROM telco_domain_phone_numbers WHERE domain_id IN(SELECT id FROM `telco_domains` WHERE `domain`=?) AND substring(dt,1,10)=?");
            $temp->execute($arrayData);
             if($temp->rowCount()){
                return json_encode($temp->fetchAll(PDO::FETCH_ASSOC));
            }else{
                return json_encode(array("Error"=>"No Records Found"));;
            }
        }catch(PDOException $e){
            echo $e->getMessage();
        }
    }
    
    /**read telcosubscribers */
    function telco_subscribers_read_offline($arrayData){
            
            $temp = $this->connect->prepare("SELECT data FROM `telco_subscribers` WHERE domain=? AND substring(dt,1,10)=?");
            $temp->execute($arrayData);
             if($temp->rowCount()){
                return $temp->fetchColumn();
            }else{
                return json_encode(array("Error"=>"No Records Found"));;
            }
             
    }
    
    /**read telcosubscribers all */
    function telco_subscribers_read_all_offline($date){
            
            $temp = $this->connect->prepare("SELECT data FROM `telco_subscribers` WHERE substring(dt,1,10)=?");
            $temp->execute([$date]);
             if($temp->rowCount()){
                return $temp->fetchAll(PDO::FETCH_ASSOC);
            }else{
                return json_encode(array("Error"=>"No Records Found"));;
            }
             
    }
    
     /**read pbxUserDeviceRead */
    function pbx_user_device_read_offline($arrayData){
            
            $temp = $this->connect->prepare("SELECT data FROM `pbx_userdevice` WHERE domain=? AND substring(dt,1,10)=?");
            $temp->execute($arrayData);
             if($temp->rowCount()){
                return $temp->fetchColumn();
            }else{
                return json_encode(array("Error"=>"No Records Found"));;
            }
             
    }
    
    
        function telco_subscribers($domain, $data){
          $temp = $this->connect->prepare("INSERT INTO `telco_subscribers`(`domain`, `data`) VALUES (?, ?)");
          $temp->execute([$domain, $data]);
          if($this->connect->lastInsertId()){
              return 1;
          }else{
              return 0;
          }
    }


    function pbxAnswerRuleInsert($domain, $user, $data){
          $temp = $this->connect->prepare("INSERT INTO `pbx_answerrules`( `domain`, `user`, `data`) VALUES (?, ?, ?)");
          $temp->execute([$domain, $user, $data]);
          if($this->connect->lastInsertId()){
              return 1;
          }else{
              return 0;
          }
    }
    
     /**read pbxSubscriberReadAnswerRules*/
    function pbxAnswerRuleRead_offline($arrayData){
            
            $temp = $this->connect->prepare("SELECT data FROM `pbx_answerrules` WHERE domain=? AND user=? AND substring(dt,1,10)=?");
            $temp->execute($arrayData);
             if($temp->rowCount()){
                return $temp->fetchColumn();
            }else{
                return json_encode(array("Error"=>"No Records Found"));;
            }
             
    }

    function pbxSubscriberReadInsert($domain, $user, $data){
          $temp = $this->connect->prepare("INSERT INTO `pbx_subscribers`( `domain`, `user`, `data`) VALUES (?, ?, ?)");
          $temp->execute([$domain, $user, $data]);
          if($this->connect->lastInsertId()){
              return 1;
          }else{
              return 0;
          }
    }
    
    /**read pbxSubscriberRead*/
    function pbxSubscriberRead_offline($arrayData){
            
            $temp = $this->connect->prepare("SELECT data FROM `pbx_subscribers` WHERE domain=? AND user=? AND substring(dt,1,10)=?");
            $temp->execute($arrayData);
             if($temp->rowCount()){
                return $temp->fetchColumn();
            }else{
                return json_encode(array("Error"=>"No Records Found"));;
            }
             
    }
    
    function pbxUserDeviceRead($domain, $data){
          $temp = $this->connect->prepare("INSERT INTO `pbx_userdevice`(`domain`,`data`) VALUES (?, ?)");
          $temp->execute([$domain, $data]);
          if($this->connect->lastInsertId()){
              return 1;
          }else{
              return 0;
          }
    }
    
    
    
    /**CRS REPORT**/
    function getCRSreport($domain,$date){

            $temp = $this->connect->prepare("SELECT Phone_Number, Carrier, Account_Number, Pin,Pin_Date, BTN ,Company, Address, City,SUBSTRING(dt,1,10) as Date FROM(SELECT thinq_did.didSummary as Phone_Number,'Thinq' as Carrier,thinq_did.account_id as Account_Number,'NA' as Pin,'NA' as Pin_Date,'919-890-0000' as 'BTN','thinQ Inc' as Company,'5420 Wade Park BLVD' as Address, 'Raleigh, NC 27607' as City,thinq_did.dt FROM `thinq_did` WHERE SUBSTRING(thinq_did.didSummary,-10) IN(SELECT SUBSTRING(phone_number,-10) FROM `telco_domain_phone_numbers` JOIN telco_domains ON telco_domain_phone_numbers.domain_id=telco_domains.id WHERE domain = :domain AND substring(telco_domain_phone_numbers.dt,1,10) = :date) AND substring(thinq_did.dt,1,10) = :date UNION SELECT telephone_bandwidth.FullNumber as Phone_Number,'BW' AS Carrier,telephone_bandwidth.AccountId as Account_Number, telephone_bandwidth.pin as Pin,telephone_bandwidth.pin_date as Pin_Date,telephone_bandwidth.FullNumber as BTN,'NA' as Company,'NA' AS Address,telephone_bandwidth.City as City,telephone_bandwidth.dt FROM `telephone_bandwidth` WHERE SUBSTRING(telephone_bandwidth.FullNumber,-10) IN (SELECT SUBSTRING(phone_number,-10) FROM `telco_domain_phone_numbers` JOIN telco_domains ON telco_domain_phone_numbers.domain_id=telco_domains.id WHERE domain = :domain AND substring(telco_domain_phone_numbers.dt,1,10) = :date) AND substring(telephone_bandwidth.dt,1,10) = :date  UNION SELECT all_telephonenumber.FullNumber as Phone_Number,'SkySwitch' AS Carrier,all_telephonenumber.AccountId as Account_Number, 'NA' as Pin,'NA' as Pin_Date,all_telephonenumber.FullNumber as BTN,'NA' as Company,'NA' AS Address,'NA' as City,all_telephonenumber.udt FROM `all_telephonenumber` WHERE SUBSTRING(all_telephonenumber.FullNumber,-10) IN(SELECT SUBSTRING(phone_number,-10) FROM `telco_domain_phone_numbers` JOIN telco_domains ON telco_domain_phone_numbers.domain_id=telco_domains.id WHERE domain = :domain AND substring(telco_domain_phone_numbers.dt,1,10) = :date) AND SUBSTRING(all_telephonenumber.FullNumber,-10) NOT IN(SELECT SUBSTRING(thinq_did.didSummary,-10)  FROM thinq_did WHERE SUBSTRING(thinq_did.didSummary,-10) IN(SELECT SUBSTRING(phone_number,-10) FROM `telco_domain_phone_numbers` JOIN telco_domains ON telco_domain_phone_numbers.domain_id=telco_domains.id WHERE domain = :domain AND substring(telco_domain_phone_numbers.dt,1,10) = :date)) AND SUBSTRING(all_telephonenumber.FullNumber,-10) NOT IN(SELECT SUBSTRING(telephone_bandwidth.FullNumber,-10) FROM `telephone_bandwidth` WHERE SUBSTRING(telephone_bandwidth.FullNumber,-10) IN (SELECT SUBSTRING(phone_number,-10) FROM `telco_domain_phone_numbers` JOIN telco_domains ON telco_domain_phone_numbers.domain_id=telco_domains.id WHERE domain = :domain AND substring(telco_domain_phone_numbers.dt,1,10) = :date)) AND substring(all_telephonenumber.dt,1,10) = :date) AS T4");
            $temp->execute(array(':domain'=>$domain,':date'=>$date));
            if($temp->rowCount()){
                return json_encode($temp->fetchAll(PDO::FETCH_ASSOC));
            }else{
                return json_encode(array("Error"=>"No Records Found"));;
            }

  }


    /**brandwidth set */

    function setAllBrandwidthTelephones($arrayData){
        
            $temp = $this->connect->prepare("INSERT INTO `telephone_bandwidth`(`City`, `Lata`, `State`, `FullNumber`, `Tier`, `VendorId`, `VendorName`, `OnNetVendor`, `RateCenter`, `Status`, `AccountId`, `LastModified`, `IsHostedVoice`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $temp->execute($arrayData);
            if($this->connect->lastInsertId()){
                return 1;
            }else{
                return 0;
            }
  }


    function setAllTelephones($arrayData){
        
       // if($this->isTelephonesNumberExist($arrayData) == 0){

            $temp = $this->connect->prepare("INSERT INTO `all_telephonenumber`(`City`, `Lata`, `State`, `FullNumber`, `Tier`, `VendorId`, `VendorName`, `OnNetVendor`, `RateCenter`, `Status`, `AccountId`, `LastModified`, `IsHostedVoice`, `Base_Origin`, `Origin`, `Type`, `Carrier_Id`, `T38`, `On_Network`, `account_id`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $temp->execute($arrayData);
            if($this->connect->lastInsertId()){
                return 1;
            }else{
                return 0;
            }

       // }
  }
  
  /**get bw numbers**/
  function getBWNumbers(){
    $temp = $this->connect->prepare("SELECT FullNumber FROM `telephone_bandwidth` WHERE substring(dt,1,10) = substring(now(),1,10)");
    $temp->execute();
     if($temp->rowCount()){
        return json_encode($temp->fetchAll(PDO::FETCH_ASSOC));
    }else{
        return json_encode(array());
    }
 }
  
   /**update BW for portoutpasscode */
 function setBWportoutPasscode($numbers){
    $temp = $this->connect->prepare("UPDATE `telephone_bandwidth` SET `pin`=555567,`pin_date`=now() WHERE FIND_IN_SET(FullNumber,:in_values)");
    $temp->execute(array(':in_values' => $numbers));
    if($temp->rowCount()){
        return json_encode(array("success"=>true));
    }else{
        return json_encode(array("success"=>false));
    }
 }
 
 
 /**update single number BW for portoutpasscode */
 function setBWportoutPasscodeSingleNumber($numbers,$pin){
    $temp = $this->connect->prepare("UPDATE `telephone_bandwidth` SET `pin`=:pin,`pin_date`=now() WHERE FullNumber=:number");
    $temp->execute(array(':number' => $numbers,':pin'=>$pin));
    if($temp->rowCount()){
        return json_encode(array("success"=>true));
    }else{
        return json_encode(array("success"=>false));
    }
 }

  function isTelephonesNumberExist($arrayData){
    $temp = $this->connect->prepare("SELECT id FROM `all_telephonenumber` WHERE FullNumber = ?");
    $temp->execute([$arrayData[3]]);
    if($temp->rowCount()){
        $id = $temp->fetchColumn();
        return $this->updateTelephoneNumbers($arrayData, $id);
    }else{
        return 0;
    }
 }

 function updateTelephoneNumbers($arrayData, $id){

    try{
        $this->connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $temp = $this->connect->prepare("UPDATE `all_telephonenumber` SET `City`=COALESCE(?, City),`Lata`=COALESCE(?, Lata),`State`=COALESCE(?, State),`FullNumber`=COALESCE(?, FullNumber),`Tier`=COALESCE(?, Tier),`VendorId`=COALESCE(?, VendorId),`VendorName`=COALESCE(?, VendorName),`OnNetVendor`=COALESCE(?, OnNetVendor),`RateCenter`=COALESCE(?, RateCenter),`Status`=COALESCE(?, Status),`AccountId`=COALESCE(?, AccountId),`LastModified`=COALESCE(?, LastModified),`IsHostedVoice`=COALESCE(?, IsHostedVoice),`Base_Origin`=COALESCE(?, Base_Origin),`Origin`=COALESCE(?, Origin),`Type`=COALESCE(?, Type),`Carrier_Id`=COALESCE(?, Carrier_Id),`T38`=COALESCE(?, T38),`On_Network`=COALESCE(?, On_Network),`account_id`=COALESCE(?, account_id),`udt` = NOW() WHERE id = ?");
        array_push($arrayData, $id);
        $temp->execute($arrayData);
        return 1;
    }catch(PDOException $e){
        echo $e->getMessage();
    }
 }

 function getAllTelephoneNumbers(){
    $temp = $this->connect->prepare("SELECT * FROM `all_telephonenumber` WHERE substring(dt,1,10) = substring(now(),1,10)");
    $temp->execute();
    if($temp->rowCount()){
        return json_encode($temp->fetchAll(PDO::FETCH_ASSOC));
    }else{
        return json_encode(array());
    }
 }

 /**route information */
 
 function getTelephoneNumbersRouteDates(){
    $temp = $this->connect->prepare("SELECT DISTINCT(SUBSTRING(dt,1,10)) AS date FROM `telephone_route` ORDER BY id DESC");
    $temp->execute();
    if($temp->rowCount()){
        return json_encode(array("success"=>true, "data" => $temp->fetchAll(PDO::FETCH_ASSOC)));
    }else{
        return json_encode(array("success"=>false, "data" => "No record found!"));
    }
 }
 
 function getTelephoneNumbersRoute($search,$date){
     
    //  $end = sizeof($date)-1;
    //  foreach($date as $index=>$date){
    //      if($end != $index){
    //       $datez.="'$date',";
    //      }else{
    //       $datez.="'$date'";
    //      }
    //  }
     
     
    $temp = $this->connect->prepare(" CALL `route_info`(:search, :date);");
    $temp->execute(array(':search'=>$search,':date'=>$date));
    if($temp->rowCount()){
        return json_encode(array("success"=>true, "data" => $temp->fetchAll(PDO::FETCH_ASSOC)));
    }else{
        return json_encode(array("success"=>false, "data" => "Record not found"));
    }
    
 }
 //nsert route info
 function setTelephoneNumbersPbxRoute($arrayData){
    $temp = $this->connect->prepare("INSERT INTO `telephone_route`( `FullNumber`, `account_id`, `type`, `enable`, `valid_from`, `valid_to`, `notes`, `caller_id_prefix`, `subscriber`, `treatment`, `company`, `deliver_offline`, `email_confirmation_on_success`, `email_confirmation_on_failure`, `email_confirmation_format`, `fax_confirmation_on_success`, `fax_confirmation_on_failure`, `fax_confirmation_format`, `email_attachment_type`, `mac_address`, `error`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $temp->execute($arrayData);
    if($temp->rowCount()){
        return $this->connect->lastInsertId();
    }else{
        return 0;
    }
 }

 function setTelephoneNumbersRouteExtraInfo($arrayData){
    $temp = $this->connect->prepare("INSERT INTO `telco_route_extra_info`(`telco_route_id`, `subscriber`, `email_addresses`, `trunk_group_id`, `deliver_email_address`, `email_confirmation_address`) VALUES (?, ?, ?, ?, ?, ?)");
    $temp->execute($arrayData);
    if($temp->rowCount()){
        return 1;
    }else{
        return 0;
    }
 }

 /**Thinq */

 //nsert route info
 function setThinqDID($arrayData){
    $temp = $this->connect->prepare("INSERT INTO `thinq_did`(`account_id`, `account_location_id`, `callerIdSummary`, `caller_id`, `carrier_id`, `carrier_name`, `carrier_tier`, `didSummary`, `external`, `foc_date`, `id`, `note`, `npanxx`, `ported`, `portin_zendesk_ticket`, `provisioned`, `route_id`, `routingSummary`, `sms_routing_profile_id`, `tag`, `tf_lcr_profile_id`, `tf_lcr_ready`, `thinq_tier`, `tollfree_prefix`, `type`, `status`,`cnam`, `e911`, `sms`, `company`, `ratecenter`,`Account_ID_virtual`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,0)");
    $temp->execute($arrayData);
    if($temp->rowCount()){
        return $this->connect->lastInsertId();
    }else{
        return 0;
    }
 }

/**insert cdr report**/

 function setCDRreport($arrayData){
     try{
    $temp = $this->connect->prepare("INSERT INTO `cdr_reports`(`domain`, `cdr_id`, `time_start`, `duration`, `term_a_mos_min_mult10`, `term_b_mos_min_mult10`, orig_b_mos_min_mult10, orig_a_mos_min_mult10,  `by_sub`, data) VALUES (?,?,?,?,?,?,?,?,?,?)");
    $temp->execute($arrayData);
    if($temp->rowCount()){
        return $this->connect->lastInsertId();
    }else{
        return 0;
    }
     }catch(PDOException $e){
         echo $e->getMessage();
     }
 }
 //last insert time
 function getCDRreportLastTime(){
    $temp = $this->connect->prepare("SELECT dt FROM `cdr_reports` ORDER BY id DESC LIMIT 1");
    $temp->execute();
    if($temp->rowCount()){
        return $temp->fetchColumn();
    }else{
        return 0;
    }
 }
 
  //last 5 cdr by domain
 function getCDRreportLastFive($domain){
    $temp = $this->connect->prepare("SELECT * FROM `cdr_reports` WHERE domain = ? ORDER BY id DESC LIMIT 10");
    $temp->execute([$domain]);
    if($temp->rowCount()){
        return $temp->fetchAll(PDO::FETCH_ASSOC);
    }else{
        return 0;
    }
 }
  

//**SVS**//
function getTelephoneRoute($tn){
    $temp = $this->connect->prepare("SELECT subscriber FROM `telephone_route` WHERE FullNumber=?  ORDER BY `id` DESC limit 1");
    $temp->execute([$tn]);
    if($temp->rowCount()){
        return $temp->fetchColumn();
    }else{
        return 0;
    }
 }
 
//**telco subscribers json**/
function telco_subscribers_read_data_offline($domain){
            
            $temp = $this->connect->prepare("SELECT data FROM `telco_subscribers` WHERE domain=? ORDER BY id DESC LIMIT 1");
            $temp->execute([$domain]);
             if($temp->rowCount()){
                return $temp->fetchColumn();
            }else{
                return 0;
            }
             
    }
 

//**telco subscribers json**/
function svs_answer_rules($domain,$user){
            
            $temp = $this->connect->prepare("SELECT data FROM `pbx_answerrules` WHERE domain=? AND user=? ORDER BY id DESC LIMIT 1");
            $temp->execute([$domain,$user]);
             if($temp->rowCount()){
                return $temp->fetchColumn();
            }else{
                return 0;
            }
             
    }
 
}


