<?php

ignore_user_abort(true);
set_time_limit(0);
require_once("../apis/pbx.php");
require_once("../model/query.php"); //backup mysql
require_once("../inc/helper.php"); //backup mysql

error_reporting(E_ALL);
ini_set('display_errors', 1);


$pbx = new Pbx();
$helper = new Helper();
$backup = new querys(); //database object
$seconds = 5;

// Custom log file path
$logFilePath = './log_cdr_report.log';

// Function to handle logging
function logEvent($message, $logFilePath) {
    $date = new DateTime();
    $formattedMessage = $date->format('Y-m-d H:i:s') . ' - ' . $message . PHP_EOL;
    file_put_contents($logFilePath, $formattedMessage, FILE_APPEND);
}

// Log script start
logEvent('Script started', $logFilePath);

register_shutdown_function(function() use ($logFilePath) {
    $error = error_get_last();
    if ($error !== null) {
        logEvent('Script terminated unexpectedly: ' . json_encode($error), $logFilePath);
    } else {
        logEvent('Script completed', $logFilePath);
    }
});

do {
    $domainsDetails = $backup->activeSummaDomain(); //get all domains wit account id
    
    
    $startTime = $backup->lastSummaCallDetailsTimeDate(); //last dt for database

    $arrayData = [];
    foreach ($domainsDetails as $item) {
	logEvent("Querying CDR starting from: {$startTime}", $logFilePath);
        $data = $pbx->pbxReadCDR($item['domain'], $item['accountid'], $startTime, null, null); //get cdr report
        //print_r($startTime);
        
        if (strlen($data) < 5) { //if cdr empty do nothing
            logEvent("No records for domain: {$item['domain']}", $logFilePath);
        } else {
            $cdrCount = 0;
            foreach (json_decode($data) as $cdr) {
                $cdrCount++;
                if ($cdr->term_sub == null) {
                    $user = $cdr->orig_sub;
                } else {
                    $user = $cdr->term_sub;
                }
		// Inside the loop where you process each $cdr
		$arrayData[] = [
		    $cdr->domain, // domain
		    $cdr->cdr_id, // cdr_id
		    $cdr->orig_from_name, // orig_from_name
		    $cdr->orig_to_user, // orig_to_user
		    $cdr->CdrR->orig_from_user, // orig_req_user
		    $cdr->duration, // duration
		    $cdr->time_start, // time_start
		    $cdr->CdrR->orig_callid, // orig_callid
		    $cdr->CdrR->term_callid, // term_callid
		    $cdr->CdrR->release_text, // release_text
		    $user, // term_sub, assuming calculation elsewhere
		    json_encode($cdr), // audio, assuming full CDR as JSON
		    0, // audio_chunk, default or calculated value
		    0, // step, default or calculated value
		    NULL, // udt, if not provided
		    0, // try, default or calculated value
		    '', // response, default or calculated value
		    '0' // fav, default value
		];
       //         $arrayData[] = [
       //             $cdr->domain,
       //             $cdr->cdr_id,
       //             $cdr->orig_from_name,
       //             $cdr->orig_to_user,
       //             $cdr->CdrR->orig_from_user,
       //             $cdr->duration,
       //             $cdr->time_start,
       //             $cdr->CdrR->orig_callid,
       //             $cdr->CdrR->term_callid,
       //             $user,
       //             $cdr->CdrR->release_text,
       //             json_encode($cdr)
       //         ];
            }
            logEvent("Processed {$cdrCount} records for domain: {$item['domain']}", $logFilePath);
        }
    }
   
if (!empty($arrayData)) {
    try {
        // Attempt to insert data into the database
        $insertResult = $backup->insertCallSumma($arrayData);
        
        // Use print_r to capture the output of $arrayData as a string for logging
        $dataArrayString = print_r($arrayData, true);
        
        // Log the result of the insert operation including the insertResult and the data being inserted
        logEvent("Attempting to insert records into database. Data: " . $dataArrayString, $logFilePath);
        
        // Log the outcome of the insertion
        logEvent("Insertion result: " . $insertResult, $logFilePath);
    } catch (Exception $e) {
        // Catch any exceptions and log the error message along with the data attempted to insert
        $dataArrayString = print_r($arrayData, true);
        logEvent("Exception encountered during database insertion: " . $e->getMessage() . ". Data attempted: " . $dataArrayString, $logFilePath);
    }

    // Clear the arrayData to prepare for the next batch
    unset($arrayData);
}
  


    sleep(10);
    $seconds += 10;
} while ($seconds <= 895);

