<?php
header("Content-type: application/json");  
require_once("../inc/helper.php");
class Telco extends Helper{

    
     
    private $telcoBaseurl = "https://telco-api.skyswitch.com/accounts/";  

    private function getToken($i){
          $url = "https://telco-api.skyswitch.com/oauth/token";    
          $data = $this->call_api($url,$this->getTelcoCredentials($i),"");
          file_put_contents($this->getTokenFromFile($i),$data);
    }

    private function getHeader($i){

           $header = array(
                   'Authorization: Bearer '.$this->tokenGenerator($i),
                   'Content-Type: application/json'
                 );
           return $header;
    }

    private function tokenGenerator($i){
          $data = json_decode(file_get_contents($this->getTokenFromFile($i)),true);
          //check is token expire then request again
          if(time()-filemtime($this->getTokenFromFile($i)) > $data['expires_in'] || isset($data['error'])){
             $this->getToken($i);
             $data = json_decode(file_get_contents($this->getTokenFromFile($i)),true);
             return $data['access_token']; 
             //die($this->jsonFailed("Refresh Again -- Token Generated -- ACCOUNT $i"));
          }else{
             return $data['access_token'];       
          }
    }
    
    /**check telco accounts configured */
    function noOfAccountConfig($aid){
       if($this->userResellerIds()<$aid){
        die($this->jsonFailed("Account $aid doesn't exist!"));
       }
    }

    function getTelcoListDomains(){
      
      for($i = 0; $i <= $this->userResellerIds(); $i++){
          $url = $this->telcoBaseurl.$this->telcoAccountId($i)."/pbx/domains"; 
          $data[] = json_decode($this->call_api($url,"",$this->getHeader($i)),true); 
      }

          foreach($data as $ac => $it1){
            foreach($it1 as $index => $it2){
              $final[$index] = array_merge($it2,array("accountid"=>$ac));
            }
          }

         return $this->jsonSuccess(json_encode($final)); 
    }


    function telcoListSubscribers($domain,$aid){

          if(empty($domain) || strlen($aid)==0){
            die($this->jsonFailed("Empty Domain or Account ID Parameter!"));
          }
      $this->noOfAccountConfig($aid);//check account exist
      $url = $this->telcoBaseurl.$this->telcoAccountId($aid)."/pbx/subscribers?domain=".$domain; 
      $data = json_decode($this->call_api($url,"",$this->getHeader($aid)),true);

      foreach($data as $index=>$item){
        $final[$index] = array_merge($item,array("accountid"=>$aid));
      }
  
      return $this->jsonSuccess(json_encode($final)); 
    }

    function telcoListPhoneNumbers($domain,$aid){

      if(empty($domain) || strlen($aid)==0){
        die($this->jsonFailed("Empty Domain or Account ID Parameter!"));
      }
      
      $this->noOfAccountConfig($aid);//check account exist
      $url = $this->telcoBaseurl.$this->telcoAccountId($aid)."/pbx/phone-numbers?domain=".$domain; 
      $data = $this->call_api($url,"",$this->getHeader($aid));   
      return $this->jsonSuccess($data); 
    }

    function telcoListAllPhoneNumbers($pageno,$aid){
      $this->noOfAccountConfig($aid);//check account exist
      $url = $this->telcoBaseurl.$this->telcoAccountId($aid)."/phone-numbers/?per_page=100&page=$pageno"; 
      $data = $this->call_api($url,"",$this->getHeader($aid));   
      return $this->jsonSuccess($data); 
    }

    function telcoListPhoneNumberRoute($phoneNo,$aid){
      $this->noOfAccountConfig($aid);//check account exist
      $url = $this->telcoBaseurl.$this->telcoAccountId($aid)."/phone-numbers/".$phoneNo."/route"; 
      $data = $this->call_api($url,"",$this->getHeader($aid));   
      return $this->jsonSuccess($data); 
    }
    
    function telcoSendMessage($sms,$msg,$aid){
      $this->noOfAccountConfig($aid);//check account exist
      $data = '{"destination":"tel:'.$sms.'","message":"'.$msg.'","callback":"https://htel.a2hosted.com/sms_callback/index.php","source_domain": "htel.23281.service","source_user": "253","source_number": "tel:16164655001"}';
      $url = $this->telcoBaseurl.$this->telcoAccountId($aid)."/messaging/send"; 
      $data = $this->call_api($url,$data,$this->getHeader($aid));   
      return $this->jsonSuccess($data); 
    }
    
    function telcoSendMessageByDomain($sms,$msg,$domain,$user,$snumber,$aid){
      $this->noOfAccountConfig($aid);//check account exist
      $data = '{"destination":"tel:'.$sms.'","message":"'.$msg.'","callback":"https://htel.a2hosted.com/sms_callback/index.php","source_domain": "'.$domain.'","source_user": "'.$user.'","source_number": "tel:'.$snumber.'"}';
      $url = $this->telcoBaseurl.$this->telcoAccountId($aid)."/messaging/send"; 
      $data = $this->call_api($url,$data,$this->getHeader($aid));   
      return $this->jsonSuccess($data); 
    }
    
    function telcoGetNumber($aid){
      $this->noOfAccountConfig($aid);//check account exist
      $url = $this->telcoBaseurl.$this->telcoAccountId($aid)."/messaging/aliases/pbxuser?domain=htel.23281.service&user=223"; 
      $data = $this->call_api($url,'',$this->getHeader($aid));   
      return $this->jsonSuccess($data); 
    }
    
    function telcoGetNumberSMSstatus($aid,$number){
      $this->noOfAccountConfig($aid);//check account exist
      $url = $this->telcoBaseurl.$this->telcoAccountId($aid)."/phone-numbers/".$number."/sms"; 
      $data = $this->call_api($url,'',$this->getHeader($aid));   
      return $this->jsonSuccess($data); 
    }

}

$telco = new Telco();
if(isset($_REQUEST["telcoAllPhoneNumber"])&&isset($_REQUEST["account_id"])){
  echo $telco->$telco->telcoListAllPhoneNumbers($_REQUEST["telcoAllPhoneNumber"],$_REQUEST["account_id"]);
}


if(isset($_REQUEST["telcoListDomain"])){
    echo $telco->getTelcoListDomains();
}

if(isset($_GET['telcoListSubscribers'])&&isset($_GET['account_id'])){
    echo $telco->telcoListSubscribers($_GET['telcoListSubscribers'],$_GET['account_id']);  
}

if(isset($_GET['telcoListPhoneNumber'])&&isset($_GET['account_id'])){
     echo $telco->telcoListPhoneNumbers($_GET['telcoListPhoneNumber'],$_GET['account_id']);  
}

if(isset($_REQUEST['sms'])&&isset($_GET['account_id'])&&isset($_REQUEST['msg'])){
    echo $telco->telcoSendMessage($_REQUEST['sms'],$_REQUEST['msg'],$_GET['account_id']);
}

if(isset($_REQUEST['isms'])&&isset($_GET['account_id'])&&isset($_REQUEST['msg'])&&isset($_REQUEST['domain'])&&isset($_REQUEST['user'])&&isset($_REQUEST['snumber'])){
    echo $telco->telcoSendMessageByDomain($_REQUEST['isms'],$_REQUEST['msg'],$_REQUEST['domain'],$_REQUEST['user'],$_REQUEST['snumber'],$_GET['account_id']);
}

//echo $telco->telcoGetNumber(0);
